/*
 * BackingStore.java
 *
 * Created on February 16, 2003, 6:26 PM
 */

package za.org.dragon.exodus;

import za.org.dragon.exodus.Conversation;
import za.org.dragon.exodus.Fragment;

import java.util.Hashtable;
import java.io.File;

import java.io.*;

/**
 *
 * @author  rdawes
 */
public class BackingStore {
    
    private String session;
    
    /** Creates a new instance of BackingStore */
    public BackingStore(String session) {
        // make sure that the session exists, either the directory, or other DB
        // requirements
        // Create a description/timestamp/person, etc in the dir or DB
        this.session = session;
    }
    
    // need to start adding exception handling! FIXME
    
    public String[] listConversations() throws IOException {
        // reads the directory, and creates a new list of conversations
        // reads the list of forms, comments, scripts, etc and add those to
        // the conversation.
        File file = new File(session);
        if (! file.isDirectory()) {
            return null;
        }
        File dir = new File(session + "conversations/");
        if (! dir.isDirectory()) {
            return null;
        }
        String[] list = dir.list();
        if (list.length == 0) {
            // /conversations/* do not exist, return no conversations
            return null;
        }
        return list;
    }
    
    public String[] listFragments() throws IOException {
        // reads the directory, and creates a new list of conversations
        // reads the list of forms, comments, scripts, etc and add those to
        // the conversation.
        File file = new File(session);
        if (! file.isDirectory()) {
            return null;
        }
        File dir = new File(session + "fragments/");
        if (! dir.isDirectory()) {
            return null;
        }
        String[] list = dir.list();
        if (list.length == 0) {
            // /fragments/* do not exist, return no fragments
            return null;
        }
        return list;
    }

    public Hashtable loadURLs() {
        return new Hashtable(1);
    }
    
    public void saveURLs(Hashtable h) {
        // write what we know about the URLs to the disk
    }
    
    public Conversation readConversation(String id) {
        // if exists on disk, create a new conversation from it, including
        // requests, responses, descriptions, etc
        Conversation c = new Conversation();
        // c.setID(id);
        c.setClientRequest(readRequest(id,"fromclient"));
        c.setServerRequest(readRequest(id,"toserver"));
        c.setServerResponse(readResponse(id,"fromserver"));
        c.setClientResponse(readResponse(id,"toclient"));
        c.setDescription(readDescription(id));
        if (c.getClientRequest() == null &&
            c.getServerRequest() == null &&
            c.getServerResponse() == null &&
            c.getClientResponse() == null &&
            c.getDescription() == null) { 
            return null;
        }
        return c;
    }
    
    public void writeConversation(Conversation conversation, String id) throws IOException {
        // get the conversation id, and write the responses, requests
        // and description to disk
        System.out.println("WriteConversation " + id);
        File f = new File(session + "conversations/" + id);
        if (!f.exists() && !f.mkdirs()) {
            System.err.println("Couldn't create the directory for " + id);
            System.exit(1);
        }
        if (conversation == null) return;
        writeRequest(conversation.getClientRequest(),id,"fromclient");
        writeRequest(conversation.getServerRequest(),id,"toserver");
        writeResponse(conversation.getServerResponse(),id,"fromserver");
        writeResponse(conversation.getClientResponse(),id,"toclient");
        writeDescription(conversation.getDescription(),id);
        writeOrigin(conversation.getOrigin(), id);
    }
    
    public Request readRequest(String id, String direction) {
        // Read the appropriate request from the disk
        File f = new File(session + "conversations/" + id + "/" + direction);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        } catch (FileNotFoundException fnfe) {
            return null;
        }
        Request r = new Request();
        try {
            r.read(fis);
            r.readContentStream();
        } catch (IOException ioe) {
            System.out.println("IOException " + ioe);
        }
        return r;
    }
    
    public void writeRequest(Request request,String id, String direction) throws IOException {
        // write the request to the disk using the requests own id
        if (request == null) {
            return;
        }
        File f = new File(session + "conversations/" + id + "/" + direction);
        FileOutputStream fos = new FileOutputStream(f);
        request.write(fos);
        fos.close();
    }
    
    public Response readResponse(String id,String direction) {
        File f = new File(session + "conversations/" + id + "/" + direction);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        } catch (FileNotFoundException fnfe) {
            return null;
        }
        Response r = new Response();
        try {
            r.read(fis);
            r.readContentStream();
        } catch (IOException ioe) {
            System.out.println("IOException " + ioe);
        }
        return r;
    }
    
    public void writeResponse(Response response, String id, String direction) throws IOException {
        // write the response to disk
        if (response == null) {
            return;
        }
        File f = new File(session + "conversations/" + id + "/" + direction);
        FileOutputStream fos = new FileOutputStream(f);
        response.write(fos);
        fos.close();
    }

//    public Fragment readFragment(String id) {
//        Fragment fragment = new Fragment();
//        fragment.setID(id);
//        File f = new File(session + "fragments/" + id);
//        BufferedInputStream bis = null;
//        try {
//            bis = new BufferedInputStream(new FileInputStream(f));
//        } catch (FileNotFoundException fnfe) {
////            System.err.println(id + " not found!");
//            return null;
//        }
//        String action = bis.r
//    }
//    
//    public void writeFragment(Response response, String id, String direction) throws IOException {
//        // write the response to disk
//        if (response == null) {
//            return;
//        }
//        File f = new File(session + "conversations/" + id + "/" + direction);
//        FileWriter fw;
//        fw = new FileWriter(f);
//        fw.write(response.toString());
//        fw.close();
//    }
//    
//    
    
    public Hashtable loadFragments() {
        return new Hashtable(1);
    }
    
    public void saveFragments(Hashtable h) {
        // write the fragments to disk
    }
    
    public Fragment readFragment(String id) {
        return new Fragment("");
    }
    
    public void writeFragment(Fragment fragment) {
        // write the fragment
    }
    
    public String readDescription(String id) {
        File f = new File(session + "conversations/" + id + "/description");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        } catch (FileNotFoundException fnfe) {
//            System.err.println(id + " not found!");
            return null;
        }
        byte[] buf = new byte[1024];
        try {
            int got = fis.read(buf);
            if (got > 0) {
                return new String(buf,0,got);
            } else {
                return null;
            }
        } catch (IOException ioe) {
            return null;
        }
    }
    
    public void writeDescription(String description, String id) throws IOException {
        // write the descriptions to disk
        File f = new File(session + "conversations/" + id + "/description");
        if (description == null || description.equals("")) {
            if (f.exists() && !f.delete()) {
                System.out.println("Error trying to delete the description for " + id + "\n");
            }
            return;
        }
        FileWriter fw = new FileWriter(f);
        fw.write(description);
        fw.close();
    }
    
    public String readOrigin(String id) {
        File f = new File(session + "conversations/" + id + "/origin");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        } catch (FileNotFoundException fnfe) {
//            System.err.println(id + " not found!");
            return null;
        }
        byte[] buf = new byte[1024];
        try {
            int got = fis.read(buf);
            if (got > 0) {
                return new String(buf,0,got);
            } else {
                return null;
            }
        } catch (IOException ioe) {
            return null;
        }
    }
    
    public void writeOrigin(String origin, String id) throws IOException {
        // write the descriptions to disk
        File f = new File(session + "conversations/" + id + "/origin");
        if (origin == null || origin.equals("")) {
            if (f.exists() && !f.delete()) {
                System.out.println("Error trying to delete the origin for " + id + "\n");
            }
            return;
        }
        FileWriter fw = new FileWriter(f);
        fw.write(origin);
        fw.close();
    }
    
    public void init() { 
        // delete all the existing data and directories in the session
        // recreate the empty directory structure
        File f = new File(session);
        if (!f.exists() && !f.mkdirs()) {
            System.err.println("Couldn't create directory for " + session);
            System.exit(1);
        } else if (!f.isDirectory()) {
            System.err.println(session + " is not a directory!");
            System.exit(1);
        }
        File c = new File(session + "conversations/");
        if (c.isDirectory()) {
            if (deleteDirectory(c)) {
                System.out.println("Successfully deleted " + c);
            } else {
                System.out.println("Couldn't delete " + c);
            }
        }
        File u = new File(session + "urlinfo/");
        if (u.isDirectory()) {
            if (deleteDirectory(u)) {
                System.out.println("Successfully deleted " + u);
            } else {
                System.out.println("Couldn't delete " + u);
            }
        }
    }
    
    private boolean deleteDirectory(File dir) {
        String[] list = dir.list();
        for (int i = 0; i<list.length; i++) {
            System.out.println("Deleting '" + list[i] + "' in " + dir.toString());
            File f = new File(dir.toString() + "/" + list[i]);
            if (f.isDirectory()) {
                deleteDirectory(f);
            }
            f.delete();
        }
        return true; // dir.delete();
    }
    
    public boolean saveUnseenURLs(String[] urls) throws IOException {
        File f = new File(session + "unseenURLs");
        FileWriter fw;
        fw = new FileWriter(f);
        
        for (int i=0; i<urls.length; i++) {
            if (urls[i] != null) {
                fw.write(urls[i]+"\n");
            }
        }
        fw.close();
        return true;
    }
    
    
    
    
    public static void main(String[] args) {
        BackingStore bs = new BackingStore("D:/temp/exodus/");
        Conversation c = bs.readConversation("00001");
        System.out.println(c.getClientRequest().toString());
        System.out.println(c.getServerResponse().toString());
        c.setDescription("Description");
//        try {
//            bs.writeConversation(c, "00000");
//        } catch (IOException ioe) {
//            System.err.println("IOException");
//        }
        
//        Response r = c.getServerResponse();
//        System.out.println(r.toString());
//        
//        BackingStore bs2 = new BackingStore("D:/java/demo3/");
//        bs2.init();
//        bs2.saveConversations(conversations);
//        bs2.saveURLs(urls);
//        bs2.saveFragments(fragments);
    }
}
