package za.org.dragon.exodus;

import java.io.*;
import java.net.*;
import javax.net.ssl.*;
import java.security.KeyStore;
import java.util.logging.Logger;

import za.org.dragon.exodus.Conversation;
import za.org.dragon.exodus.Model;

public class ConnectionHandler implements Runnable {
    
/*-----------------------------------------------------------------------+
|  PRIVATE PART                                                          |
+-----------------------------------------------------------------------*/
    
    private Model model;
    private ExodusPlugin[] plugins = null;
    private Logger logger = Logger.getLogger("za.org.dragon.exodus.ConnectionHandler");
    private Socket sock;
    private InputStream clientin;
    private OutputStream clientout;
    private SSLSocket sslsock;
    
    private boolean isSSL = false;
    
    private Thread thread;
    
    private String sslDestination;
    private String sslServer = "";
    private int sslPort = 0;
    
    String keystore = "/serverkeys";
    char keystorepass[] = "password".toCharArray();
    char keypassword[] = "password".toCharArray();
    
    //    private void washHeaders(Headers headers) {
    //        if (doNoCache) {
    //            headers.setHeader("Expires", "Sun Nov  6 08:49:37 1994");
    //            headers.setHeader("Pragma", "no-cache");
    //            headers.setHeader("Cache-Control", "private,no-cache,no-store");
    //        }
    //    }
    
    
/*-----------------------------------------------------------------------+
|  PUBLIC INTERFACE                                                      |
+-----------------------------------------------------------------------*/
    public ConnectionHandler(Model model, ExodusPlugin[] plugins, Socket sock) {
        this.model = model;
        this.plugins = plugins;
        this.sock = sock;
        try {
            sock.setTcpNoDelay(true);
            sock.setSoTimeout(5 * 60 * 1000);
        } catch (SocketException se) {
            logger.warning("Error setting socket parameters");
        }
        thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }
    
    /* Runnable *********************************************************/
    
    public void run() {
        try {
            clientin = sock.getInputStream();
            clientout = sock.getOutputStream();
        } catch (IOException ioe) {
            logger.warning("Error attaching streams to the socket");
            try {
                sock.close();
            } catch (IOException ioe2) {
                logger.warning("Error closing client socket : " + ioe2);
            }
            return;
        }
        logger.info("Reading request from browser");
        Request request = new Request();
        try {
            request.read(clientin);
        } catch (IOException ioe) {
            logger.severe("IOException reading from the browser " + ioe);
            try {
                sock.close();
            } catch (IOException ioe2) {}
            return;
        }
        logger.info("Read request from browser : " + request.getMethod() + " " + request.getURL());
        if (request.getMethod().equalsIgnoreCase("connect")) {
            Response sslOK = new Response();
            sslOK.setVersion("HTTP/1.0");
            sslOK.setStatus("200");
            sslOK.setMessage("Ok");
            
            String proxyAuth = request.getHeader("Proxy-Authorization");
            if (proxyAuth == null) {
                proxyAuth = "";
            }
            logger.info("Intercepting SSL connection!");
            try {
                sslOK.write(clientout);
                clientout.flush();
            } catch (IOException ioe) {
                logger.severe("IOException writing the CONNECT OK Response to the browser");
            }
            
            KeyStore ks = null;
            KeyManagerFactory kmf = null;
            SSLContext sslcontext = null;
            try {
                ks = KeyStore.getInstance("JKS");
                ks.load(this.getClass().getResourceAsStream(keystore), keystorepass);
                kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, keypassword);
                sslcontext = SSLContext.getInstance("SSLv3");
                sslcontext.init(kmf.getKeyManagers(), null, null);
            } catch (Exception e) {
                logger.severe("Exception accessing keystore: " + e);
                try {
                    sock.close();
                } catch (IOException ioe) {}
                return;
            }
            SSLSocketFactory factory = sslcontext.getSocketFactory();
            
            try {
                sslsock=(SSLSocket)factory.createSocket(sock,sock.getInetAddress().getHostName(),sock.getPort(),true);
                sslsock.setUseClientMode(false);
            } catch (IOException ioe) {
                logger.severe("Error layering SSL over the existing socket");
                try {
                    sock.close();
                } catch (IOException ioe2) {}
                return;
            }
            logger.info("Finished negotiating SSL - algorithm is " + sslsock.getSession().getCipherSuite());
            try {
                clientin = sslsock.getInputStream();
                clientout = sslsock.getOutputStream();
                request = readRequest(clientin,request.getURL());
                if (request == null) {
                    logger.warning("Error reading the tunneled SSL request");
                    try {
                        sock.close();
                    } catch (IOException ioe) {}
                    return;
                }
            } catch (IOException ioe) {
                logger.severe("Error attaching an SSL stream to the socket");
                try {
                    sock.close();
                } catch (IOException ioe2) {}
                return;
            }
            logger.info("Read request from browser : " + request.getMethod() + " " + request.getURL());
            if (!proxyAuth.equals("")) {
                request.setHeader("Proxy-Authorization",proxyAuth);
            }
        }
        try {
            String length = request.getHeader("Content-Length");
            if (length != null) {
                int cl = Integer.parseInt(length);
                InputStream is = request.getContentStream();
                if (is != null) {
                    request.setContentStream(new FixedLengthInputStream(is,cl));
                }
            }
        } catch (NumberFormatException nfe) {
            logger.severe("Error parsing Content-Length : " + nfe);
        }
        
        URLFilter uf = new URLFetcher();
        URLFilter serverLog = new URLLogger(uf, true);
        uf = serverLog;
        
        // put all the plugins into the chain
        for (int i=0; i < plugins.length; i++) {
            if (plugins[i] != null) {
                uf = plugins[i].getFilter(uf);
            }
        }
        
        URLFilter clientLog = new URLLogger(uf, false);
        uf = clientLog;
        
        // We've read the request, now send it to the server, and get the response
        logger.info("Sending request to server");
        Response response = uf.fetchResponse(request);
        
        if (response != null) {
            logger.info("Got response from server " + response.getStatusLine());
            
            // now write the response to the browser
            logger.info("Writing response to the browser");
            try {
                response.write(clientout);
            } catch (IOException ioe) {
                logger.severe("IOException writing response to the client " + ioe);
            }
            logger.info("Done writing response to the browser");
        } else {
            logger.severe("Got no response from the server!");
        }
        try {
            if (isSSL) {
                // close down the SSL stuff;
            }
            clientin.close();
            clientout.close();
            sock.close();
        } catch (Exception e) {
            logger.warning("Got an error trying to close the socket : " + e);
        }
        
        String conversationID = model.newConversationID();
        request = serverLog.getRequest();
        if (request != null && request.getContentStream() != null) {
            request.setContent(((CopyInputStream)request.getContentStream()).toByteArray());
        }
        model.setServerRequest(conversationID, request);
        request = clientLog.getRequest();
        if (request != null && request.getContentStream() != null) {
            request.setContent(((CopyInputStream)request.getContentStream()).toByteArray());
        }
        model.setClientRequest(conversationID, request);
        response = serverLog.getResponse();
        if (response != null && response.getContentStream() != null) {
            response.setContent(((CopyInputStream)response.getContentStream()).toByteArray());
        }
        model.setServerResponse(conversationID, response);
        response = clientLog.getResponse();
        if (response != null && response.getContentStream() != null) {
            response.setContent(((CopyInputStream)response.getContentStream()).toByteArray());
        }
        model.setClientResponse(conversationID, response);
        model.setOrigin(conversationID, "Proxy");
    }
    
    private Request readRequest(InputStream in, URL base) {
        Request request = null;
        try {
            request = new Request();
            request.setBaseURL(base);
            request.read(in);
        } catch (Exception e) {
            logger.warning("Error parsing request " + e);
        }
        return request;
    }
    
    private Response errorResponse(Request request, String message) {
        Response response = new Response();
        response.setStatus("500");
        response.setMessage("Exodus error");
        String template = "<HTML><HEAD><TITLE>Exodus Error</TITLE></HEAD>";
        template = template + "<BODY>Exodus caused an error trying to retrieve <pre>" + request.toString() + "</pre><P>";
        template = template + "The error was : <pre>" + message + "</pre><P></HTML>";
        response.setContent(template.getBytes());
        return response;
    }
    
}
