/*
 * Cookie.java
 *
 * Created on April 12, 2003, 10:42 PM
 */

package za.org.dragon.exodus;

import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.net.URL;
import java.net.MalformedURLException;

/**
 *
 * @author  rdawes
 */
public class Cookie {
    
    private String domain = "";
    
    private String path = "/";
    
    private String name = "";
    
    private String value = "";
    
    private Date setDate;
    
    private Date expiry = new Date(0);
    
    private boolean secure = false;
    
    /** Creates a new instance of Cookie */
    public Cookie(String headerValue, String setDate) {
        this(headerValue, setDate, null);
    }
    
    /** Creates a new instance of Cookie */
    public Cookie(String headerValue, String setDate, URL url) {
        if (headerValue == null) {
            return;
        }
        if (url != null) {
            this.domain = url.getHost();
        }
        this.setDate = rfc822(setDate);

		String[] parts = headerValue.split(" *; *");
        this.name = parts[0].substring(0,parts[0].indexOf("="));
        this.value = parts[0].substring(parts[0].indexOf("=")+1);
        for (int i=1; i<parts.length; i++) {
			String var = parts[i].substring(0,parts[0].indexOf("="));
			String val = parts[i].substring(parts[0].indexOf("=")+1);
			if (var.equals("path")) {
				this.path = val;
				System.out.println("Setting path to " + val);
			} else if (var.equals("expires")) {
				this.expiry = rfc822(val);
				System.out.println("Setting exires to " + val);
			} else if (var.equals("domain")) {
				this.domain = val;
				System.out.println("Setting domain to " + val);
			}
        }
    }
    
    public Cookie(String domain, String name, String path, String value, String setDate) {
        this.domain = domain;
        this.name = name;
        this.path = path;
        this.value = value;
        this.setDate = rfc822(setDate);
    }
    
    // example :    Tue, 04 Mar 2003 20:26:50 GMT
    private Date rfc822(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        } catch (ParseException pe) {}
        return date;
    }
    
    public String getDomain() {
        return domain;
    }
    
    public String getPath() {
        return path;
    }
    
    public Date getDate() {
        return setDate;
    }
    
    public Date getExpiry() {
        return expiry;
    }
    
    public String getName() {
        return name;
    }
    
    public String getValue() {
        return value;
    }
    
    public boolean isSecure() {
        return secure;
    }
    
    public String toString() {
        return new String(new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(setDate) + " : " + name + "=" + value);
    }
    
    public static void main(String[] args) {
        URL url = null;
        try {
            url = new URL("http://www.absa.co.za/");
        } catch (MalformedURLException mue) {}
        String cookieStr = "vgnvisitor=-QAAN0000c80007LfCk05WgNza; path= /; expires=Saturday, 06-Sep-2014 23:50:08 GMT";
        Cookie cookie = new Cookie(cookieStr,"Tue, 04 Mar 2003 19:35:51 GMT", url);
        System.out.println(cookie.getName());
        System.out.println(cookie.getValue());
        System.out.println(cookie.getDate());
        System.out.println(cookie.getDomain() + cookie.getPath());
        
    }

}
