/*
 * Cookie.java
 *
 * Created on April 12, 2003, 10:42 PM
 */

package za.org.dragon.exodus;

import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Vector;
import java.util.TreeMap;
import java.util.Map;
import java.util.Collections;
import java.util.Iterator;

/**
 *
 * @author  rdawes
 */
public class CookieJar {
    
    private Map cookies;
    
    /** Creates a new instance of CookieJar */
    public CookieJar() {
        cookies = Collections.synchronizedMap(new TreeMap());
    }
    
    public void clear() {
        cookies.clear();
    }
    
    public Cookie add(Conversation c) {
        Response resp = c.getServerResponse();
        Request req = c.getServerRequest();
        if (req == null) {
            req = c.getClientRequest();
        }
        return add(c.getID(), req, resp);
    }
    
//    public Cookie add(Response resp) {
//        return add(null, resp.getRequest(), resp);
//    }
    
    public Cookie add(String id, Request req, Response resp) {
        if (req == null || resp == null) {
            return null;
        }
        String setCookie = resp.getHeader("Set-Cookie");
        String setDate = resp.getHeader("Date");
        if (setCookie == null || setDate == null) {
            return null;
        }
        URL url = req.getURL();
        if (url == null) {
            return null;
        }
        
        Map paths;
        Map names;
        Vector instances;
        
        String domain = url.getHost();
        // but also look for the "domain" field of the cookie itself!
        
        String[] parts = setCookie.split(" *; *");
        String name = parts[0].substring(0,parts[0].indexOf("="));
        String value = parts[0].substring(parts[0].indexOf("=")+1);
        String path = parts[1].substring(parts[1].indexOf("=")+1).trim();
        //        for (int i=0; i<parts.length; i++) {
        //        }
        
        if (cookies.containsKey(domain)) {
            paths = (Map)cookies.get(domain);
        } else {
            paths = Collections.synchronizedMap(new TreeMap());
        }
        if (paths.containsKey(path)) {
            names = (Map) paths.get(path);
        } else {
            names = Collections.synchronizedMap(new TreeMap());
        }
        if (names.containsKey(name)) {
            instances = (Vector) names.get(name);
        } else {
            instances = new Vector(1);
        }
        instances.add(new Object[] {value, rfc822(setDate), id} );
        names.put(name,instances);
        paths.put(path,names);
        cookies.put(domain, paths);
        return new Cookie(domain, name, path, value, setDate);
    }
    
    public String[] getDomains() {
        String[] domain = new String[cookies.size()];
        int i=0;
        for (Iterator e = cookies.keySet().iterator() ; e.hasNext(); ) {
            domain[i++] = (String) e.next();
        }
        return domain;
    }
    
    public String[] getPaths(String domain) {
        Map paths = (Map) cookies.get(domain);
        String[] path = new String[paths.size()];
        int i=0;
        for (Iterator e = paths.keySet().iterator() ; e.hasNext(); ) {
            path[i++] = (String) e.next();
        }
        return path;
    }
    
    public String[] getNames(String domainPath) {
        int pos = domainPath.indexOf("/");
        if (pos>-1) {
            String domain = domainPath.substring(0,pos);
            String path = domainPath.substring(pos);
            return getNames(domain, path);
        }
        return null;
    }
    
    public String[] getNames(String domain, String path) {
        Map paths = (Map) cookies.get(domain);
        Map names = (Map) paths.get(path);
        String[] name = new String[names.size()];
        int i=0;
        for (Iterator e = names.keySet().iterator() ; e.hasNext(); ) {
            name[i++] = (String) e.next();
        }
        return name;
    }
    
    public Vector getInstances(String domainPath, String name) {
        int pos = domainPath.indexOf("/");
        if (pos>-1) {
            String domain = domainPath.substring(0,pos);
            String path = domainPath.substring(pos);
            return getInstances(domain, path, name);
        }
        return null;
    }
    
    public Vector getInstances(String domain, String path, String name) {
        Map paths = (Map) cookies.get(domain);
        Map names = (Map) paths.get(path);
        return (Vector) names.get(name);
    }
    
    // example :    Tue, 04 Mar 2003 20:26:50 GMT
    private Date rfc822(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        } catch (ParseException pe) {}
        return date;
    }
    
    //    public String toString() {
    //        return new String(new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(getDate()) + " : " + name + "=" + getValue());
    //    }
    
    public static void main(String[] args) {
        Model model = new Model();
        CookieJar cookiejar = null; // model.getCookieJar();
        
        Conversation c = new Conversation();
        try {
            Request req = new Request();
            req.setMethod("GET");
            req.setURL("http://www.absa.co.za/");
            req.setVersion("HTTP/1.0");
            c.setClientRequest(req);
            
            Response resp = new Response();
            resp.setVersion("HTTP/1.0");
            resp.setStatus("302");
            resp.setMessage("Moved temporarily");
            resp.setHeader("Set-Cookie","vgnvisitor=-QAAN0000c80007LfCk05WgNza; path= /; expires=Saturday, 06-Sep-2014 23:50:08 GMT");
            resp.setHeader("Date", "Tue, 04 Mar 2003 20:26:50 GMT");
            c.setServerResponse(resp);
//            model.setConversation(c);
        } catch (MalformedURLException mue) {
            System.out.println("Can't create the request " + mue);
            System.exit(1);
        }
        String domain = cookiejar.getDomains()[0];
        System.out.println(domain);
        String path = cookiejar.getPaths(domain)[0];
        System.out.println(path);
        String name = cookiejar.getNames(domain + path)[0];
        System.out.println(name);
    }
    
}
