/*
 * $Id: Element.java,v 1.1 2003/05/25 20:06:20 rdawes Exp $
 * Created on May 21, 2003
 *
 */
package za.org.dragon.exodus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * @author chandler howell
 *
 * An element is a control in a form
 *
 */
public class Element {
    /** The attributes of the element, such as type, name, etc */
    private HashMap attributes = new HashMap();
    
    /** The keys in order they were encountered */
    private List keyList = new ArrayList();
    
    /** The element type: input, textarea, etc */
    private String elementType = "";
    
    /**
     * On elements which enclose text, such as textarea's, store
     * that text here.
     *
     * TO-DO: In a perfect world, this should be subclassed.
     */
    private String enclosedText = null;
    
    
    public String getEnclosedText() {
        if ( enclosedText == null)
            return "";
        
        return enclosedText;
    }
    
    public void setEnclosedText( String text ) {
        enclosedText = text;
    }
    
    /**
     * Get the type of element.  This is different from the "type"
     * attribute, which tells if this is a checkbox, textbox, etc.
     *
     * @return The element type (input, textarea, etc.)
     */
    public String getElementType() {
        return elementType;
    }
    
    public Element() {
        ;
    }
    
    /**
     * Create a new element of a given type
     * @param type The element type (input, textarea, etc.)
     */
    public Element( String type ) {
        elementType = type;
    }
    
    /**
     * Get a list of the attributes of the element
     *
     * @return A copy of the List of the attributes of this form element
     */
    public List getattributeNames() {
        return new ArrayList( keyList );
    }
    
    /**
     * Get the value of a given attribute
     *
     * @param attrName The name of the attribute to query for
     * @return The value of the requested attribute
     */
    public String getAttribute( String attrName ) {
        String value = (String)attributes.get( attrName );
        if ( value == null )
            value = "";
        
        return value;
    }
    
    
    public void addAttribute( String name, String value ) {
        attributes.put( name, value );
        keyList.add( name );
    }
    
    
    public String removeAttribute( String name ) {
        keyList.remove( name );
        return (String)attributes.remove( name );
    }
    
    
    public String toString() {
        StringBuffer sb = new StringBuffer( "<" + elementType );
        Iterator i = keyList.iterator();
        while ( i.hasNext() ) {
            String key = (String)i.next();
            sb.append( " " + key + "=\"" + attributes.get( key ) + "\"" );
        }
        sb.append( ">");
        
        if ( enclosedText != null ) {
            sb.append( enclosedText + "</" + elementType + ">" );
        }
        
        return sb.toString();
    }
    
}
