/*
 * ProxyConfig.java
 *
 * Created on March 30, 2003, 7:48 AM
 */

package za.org.dragon.exodus;

import java.util.Properties;

/**
 *
 * @author  rdawes
 */
public class ExodusConfig extends javax.swing.JPanel {
    
    private Exodus exodus = null;
    
    /** Creates new form ProxyConfig */
    public ExodusConfig(Exodus exodus) {
        this.exodus = exodus;
        initComponents();
        
        Properties props = exodus.getProperties();
        
        listenServerTextField.setText(props.getProperty("Exodus.listenHost"));
        listenPortTextField.setText(props.getProperty("Exodus.listenPort"));
        String[] httpProxy = props.getProperty("Exodus.httpProxy").split(":");
        httpProxyServerTextField.setText(httpProxy.length == 2 ? httpProxy[0] : "");
        httpProxyPortTextField.setText(httpProxy.length == 2 ? httpProxy[1] : "");
        String[] httpsProxy = props.getProperty("Exodus.httpsProxy").split(":");
        httpsProxyServerTextField.setText(httpsProxy.length == 2 ? httpsProxy[0] : "");
        httpsProxyPortTextField.setText(httpsProxy.length == 2 ? httpsProxy[1] : "");
        noProxyTextArea.setText(props.getProperty("Exodus.noProxy"));
    }
    
    public String acceptConfig(boolean commit) {
        Properties props = exodus.getProperties();
        String value = listenServerTextField.getText();
        String prop = "Exodus.listenHost";
        if (commit && !value.equals(props.getProperty(prop))) {
            props.setProperty(prop, value);
        }
        try {
            value = listenPortTextField.getText();
            prop = "Exodus.listenPort";
            int p = Integer.parseInt(value);
            if (commit && !value.equals(props.getProperty(prop))) {
                props.setProperty(prop, value);
            }
        } catch (NumberFormatException nfe) {
            return new String("Error parsing the port to listen on");
        }
        try {
            String server = httpProxyServerTextField.getText().trim();
            String port = httpProxyPortTextField.getText().trim();
            value = server + ":" + port;
            prop = "Exodus.httpProxy";
            if (!server.equals("") && !port.equals("")) {
                int p = Integer.parseInt(port);
                if (commit && !value.equals(props.getProperty(prop))) {
                    props.setProperty(prop,value);
                }
            } else if (port.equals("") && !server.equals("")) {
                return new String("The http Proxy port must also be provided");
            } else if (server.equals("") && !port.equals("")) {
                return new String("The http Proxy server must also be provided");
            }
        } catch (NumberFormatException nfe) {
            return new String("Error parsing the upstream HTTP Proxy port");
        }
        try {
            String server = httpsProxyServerTextField.getText().trim();
            String port = httpsProxyPortTextField.getText().trim();
            value = server + ":" + port;
            prop = "Exodus.httpsProxy";
            if (!server.equals("") && !port.equals("")) {
                int p = Integer.parseInt(port);
                if (commit && !value.equals(props.getProperty(prop))) {
                    props.setProperty(prop,value);
                }
            } else if (port.equals("") && !server.equals("")) {
                return new String("The https Proxy port must also be provided");
            } else if (server.equals("") && !port.equals("")) {
                return new String("The https Proxy server must also be provided");
            }
        } catch (NumberFormatException nfe) {
            return new String("Error parsing the upstream HTTPS Proxy port");
        }
        value = noProxyTextArea.getText();
        prop = "Exodus.noProxy";
        if (commit && !value.equals(props.getProperty(prop))) {
            props.setProperty(prop,value);
        }
        exodus.configure(props);
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel6 = new javax.swing.JLabel();
        listenServerTextField = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        listenPortTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        httpProxyServerTextField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        httpProxyPortTextField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        httpsProxyServerTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        httpsProxyPortTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        noProxyTextArea = new javax.swing.JTextArea();
        fillerLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        jLabel6.setText("Listen on : ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel6, gridBagConstraints);

        listenServerTextField.setMinimumSize(new java.awt.Dimension(150, 20));
        listenServerTextField.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(listenServerTextField, gridBagConstraints);

        jLabel7.setText("Port :");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel7, gridBagConstraints);

        listenPortTextField.setMinimumSize(new java.awt.Dimension(60, 20));
        listenPortTextField.setPreferredSize(new java.awt.Dimension(60, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(listenPortTextField, gridBagConstraints);

        jLabel2.setText("HTTP  Proxy : ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel2, gridBagConstraints);

        httpProxyServerTextField.setMinimumSize(new java.awt.Dimension(150, 20));
        httpProxyServerTextField.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(httpProxyServerTextField, gridBagConstraints);

        jLabel5.setText("Port :");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel5, gridBagConstraints);

        httpProxyPortTextField.setMinimumSize(new java.awt.Dimension(60, 20));
        httpProxyPortTextField.setPreferredSize(new java.awt.Dimension(60, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(httpProxyPortTextField, gridBagConstraints);

        jLabel4.setText("HTTPS Proxy : ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel4, gridBagConstraints);

        httpsProxyServerTextField.setMinimumSize(new java.awt.Dimension(150, 20));
        httpsProxyServerTextField.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(httpsProxyServerTextField, gridBagConstraints);

        jLabel3.setText("Port :");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel3, gridBagConstraints);

        httpsProxyPortTextField.setMinimumSize(new java.awt.Dimension(60, 20));
        httpsProxyPortTextField.setPreferredSize(new java.awt.Dimension(60, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(httpsProxyPortTextField, gridBagConstraints);

        jLabel1.setText("No Proxy : ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel1, gridBagConstraints);

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setMinimumSize(new java.awt.Dimension(100, 48));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(103, 51));
        noProxyTextArea.setLineWrap(true);
        noProxyTextArea.setToolTipText("Enter a comma separated list of hosts that do not need to go through the proxy");
        noProxyTextArea.setPreferredSize(null);
        jScrollPane1.setViewportView(noProxyTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(fillerLabel, gridBagConstraints);

    }//GEN-END:initComponents
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel fillerLabel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField httpsProxyServerTextField;
    private javax.swing.JTextField httpsProxyPortTextField;
    private javax.swing.JTextField httpProxyPortTextField;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JTextField listenPortTextField;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JTextArea noProxyTextArea;
    private javax.swing.JTextField httpProxyServerTextField;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField listenServerTextField;
    // End of variables declaration//GEN-END:variables
    
}
