/*
 * $Id: ExodusPlugin.java,v 1.6 2003/06/11 05:18:24 rdawes Exp $
 * ExodusPlugin.java
 *
 * Created on March 29, 2003, 9:30 AM
 */

package za.org.dragon.exodus;

/**
 *
 * @author  rdawes
 */
public abstract interface ExodusPlugin {
    
    /* this is the first non-constructor method that should be called.
     * It should generally take care of any initialisation that is required
     */
    
    public void init(Exodus exodus);
    
    /* This method is used to configure the plugin based on any user 
     * or default properties that may exist. Typically, the plugin
     * developer will include a set of defaults in the source as well
     */

    public void setProperties(java.util.Properties properties);
    
    /* This returns a string describing the plugin.
     * It is only used to name the tabs in the GUI interface, at this point
     */
    public String getPluginName();
    
    /* This returns an URLFilter class that can be used to dynamically modify
     * a request or response as it passes through to the provided URLFilter.
     */
    public URLFilter getFilter(URLFilter uf);
    
    /* returns a panel containing the main GUI interface, or null
     * if this plugin does not require a panel in the main GUI
     */
    public javax.swing.JPanel createMainInterface();
    
    /* returns a panel containing an options/configuration interface
     * or null if this plugin does not require a panel in the options dialog
     */
    public javax.swing.JPanel createConfigInterface();
    
    /* called first with commit == false when the OK button is pressed
     * if it returns null, it may be called again with commit == true
     * in order to commit any config options that have been set.
     * It MAY also be called again with commit == false, if another plugin
     * returned a non-null indicating a validation error
     */
    public String acceptConfig(boolean commit);
    
    /* intended to allow the plugin to do their own saving to a database of some sort
     * This has not been implemented, and will not be called at this point
     */
    public void setDB(java.sql.Connection dbcon, String session);
    
    /* intended to allow the plugin to do their own setup of a database to read or save
     * any results. This would be called once to allow the plugin to create tables, etc
     * This has not been implemented, and will not be called at this point
     */
    public void initDB();
    
    /* This will be called if a new session is read in. The plugin should discard any 
     * data structures, and reinitialise them
     */
    public void clearSession();
    
}
