/*
 * ExodusUI.java
 *
 * Created on February 12, 2003, 6:34 AM
 */

package za.org.dragon.exodus;


import java.util.Properties;
import java.util.Enumeration;

import java.io.File;
import java.io.IOException;

import javax.swing.JPanel;
import javax.swing.JFileChooser;

// Panels to be added into the main UI
import za.org.dragon.exodus.ExodusPlugin;

import za.org.dragon.exodus.TranscoderFrame;

/**
 *
 * @author  rdawes
 */
public class ExodusUI extends javax.swing.JFrame implements Runnable {
    
    Model model = null;    // Stores our model reference
    
    Exodus exodus = null;
    MessageLog messageLog;
    TranscoderFrame transcoder = null;
    
    // Stores the panels loaded into the UI
    ExodusPlugin[] plugins = null;
    
    public ExodusUI(Exodus exodus) {
        this.exodus = exodus;
        this.model = exodus.getModel();
        this.plugins = exodus.getPlugins();
        initComponents();
        messageLog = new MessageLog();
        if (plugins != null) {
            addPlugins(plugins);
        }
        mainSplitPane.setBottomComponent(messageLog);
    }
    
    private void addPlugins(ExodusPlugin plugins[]) {
        for (int i=0; i<plugins.length; i++) {
            if (plugins[i] != null) {
                JPanel panel = plugins[i].createMainInterface();
                if (panel != null) {
                    mainTabbedPane.add(plugins[i].getPluginName(),panel);
                }
            }
        }
    }
    
    public MessageLog getMessageLog() {
        return messageLog;
    }
    
    public void log(String message) {
        if (messageLog == null) {
            System.out.println("ExodusUI : " + message);
        } else {
            messageLog.log("ExodusUI : " + message);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mainSplitPane = new javax.swing.JSplitPane();
        mainTabbedPane = new javax.swing.JTabbedPane();
        mainMenuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        saveMenuItem = new javax.swing.JMenuItem();
        exitMenuItem = new javax.swing.JMenuItem();
        toolsMenu = new javax.swing.JMenu();
        transcoderMenuItem = new javax.swing.JMenuItem();
        optionsMenuItem = new javax.swing.JMenuItem();
        saveOptionsMenuItem = new javax.swing.JMenuItem();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Exodus");
        setName("exodusFrame");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        mainSplitPane.setBorder(null);
        mainSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        mainSplitPane.setResizeWeight(0.9);
        mainSplitPane.setMinimumSize(null);
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setPreferredSize(null);
        mainSplitPane.setLeftComponent(mainTabbedPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(mainSplitPane, gridBagConstraints);

        fileMenu.setText("File");
        openMenuItem.setText("Open");
        openMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(openMenuItem);

        saveMenuItem.setText("Save");
        fileMenu.add(saveMenuItem);

        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(exitMenuItem);

        mainMenuBar.add(fileMenu);

        toolsMenu.setText("Tools");
        transcoderMenuItem.setText("Transcoder");
        transcoderMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                transcoderMenuItemActionPerformed(evt);
            }
        });

        toolsMenu.add(transcoderMenuItem);

        optionsMenuItem.setText("Options");
        optionsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optionsMenuItemActionPerformed(evt);
            }
        });

        toolsMenu.add(optionsMenuItem);

        saveOptionsMenuItem.setText("Save settings");
        saveOptionsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveOptionsMenuItemActionPerformed(evt);
            }
        });

        toolsMenu.add(saveOptionsMenuItem);

        mainMenuBar.add(toolsMenu);

        setJMenuBar(mainMenuBar);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(800, 600));
        setLocation((screenSize.width-800)/2,(screenSize.height-600)/2);
    }//GEN-END:initComponents

    private void transcoderMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_transcoderMenuItemActionPerformed
        if (transcoder == null) {
            transcoder = new TranscoderFrame();
        }
        transcoder.show();
    }//GEN-LAST:event_transcoderMenuItemActionPerformed

    private void saveOptionsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveOptionsMenuItemActionPerformed
        exodus.writeProperties();
    }//GEN-LAST:event_saveOptionsMenuItemActionPerformed

    private void saveMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveMenuItemActionPerformed
        
    }//GEN-LAST:event_saveMenuItemActionPerformed

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        // Add your handling code here:
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void openMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openMenuItemActionPerformed
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(ExodusUI.this);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            //This is where a real application would open the file.
            log("Opening: " + file.toString());
            load(file.toString() + "/");
        } else {
            log("Open command cancelled by user");
        }
    }//GEN-LAST:event_openMenuItemActionPerformed

    public void load(String session) {
        exodus.load(session);
    }
    
    private void optionsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optionsMenuItemActionPerformed
        new OptionsDialog(exodus, this).show();
    }//GEN-LAST:event_optionsMenuItemActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    public void run() {
        this.show();
    }
    
    private za.org.dragon.exodus.Conversation conversation;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane mainSplitPane;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenuItem transcoderMenuItem;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenuItem saveMenuItem;
    private javax.swing.JMenuBar mainMenuBar;
    private javax.swing.JMenuItem saveOptionsMenuItem;
    private javax.swing.JMenuItem openMenuItem;
    private javax.swing.JTabbedPane mainTabbedPane;
    private javax.swing.JMenuItem optionsMenuItem;
    private javax.swing.JMenu toolsMenu;
    // End of variables declaration//GEN-END:variables
    
}
