/*
 * Fragment.java
 *
 * Created on February 15, 2003, 6:10 PM
 */

package za.org.dragon.exodus;

import za.org.dragon.exodus.Comment;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import java.util.Hashtable;

/**
 *
 * @author  rdawes
 */
public class Fragment {

    private static Hashtable fragmentHash = new Hashtable();
    
    private String digest = null;
    private String body;
    private Comment comment;
    
    public static Fragment get(String digest) {
        return (Fragment) fragmentHash.get(digest);
    }
    
    /** Creates a new instance of Fragment */
    public Fragment(String fragment) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException nsae) {
            System.err.println("Can't calculate MD5 sums! No such algorithm!");
            System.exit(1);
        }
        this.digest = hexEncode(md.digest(fragment.getBytes()));
        if (!fragmentHash.containsKey(digest)) {
            this.comment = new Comment("Review","");
            this.body = fragment;
            fragmentHash.put(digest,this);
        } else {
            this.comment = null;
            this.body = null;
        }
    }
    
    public String getBody() {
        if (body == null) {
            return Fragment.get(digest).getBody();
        } else {
            return body;
        }
    }
    
    public String getComment() {
        if (comment == null) {
            return Fragment.get(digest).getComment();
        } else {
            return comment.getComment();
        }
    }
    
    public void setComment(String comment) {
        if (this.comment != null) {
            this.comment.setComment(comment);
        } else {
            Fragment.get(digest).setComment(comment);
        }
    }
    
    public String getStatus() {
        if (comment == null) {
            return Fragment.get(digest).getStatus();
        } else {
            return comment.getStatus();
        }
    }
    
    public void setStatus(String status) {
        if (this.comment != null) {
            this.comment.setStatus(status);
        } else {
            Fragment.get(digest).setStatus(status);
        }
    }
    
    public String toString() {
        return digest.toString();
    }

    private String hexEncode(byte[] bytes) {
        char[] hex = new char[] { '0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f' };
        StringBuffer hexBuff = new StringBuffer();
        for ( int i = 0; i < bytes.length; i++ ) {
            hexBuff.append(new char[] {hex[(bytes[i]>>4)&0xf],hex[bytes[i]&0xf]});
        }
        return hexBuff.toString().toUpperCase();
    }

    public static void main(String args[]) {
        Fragment fragment = new Fragment("test");
        System.out.println("body = '" + fragment.getBody() + "'");
        System.out.println("comment = '" + fragment.getComment() + "'");
        System.out.println("status = '" + fragment.getStatus()+ "'");
        String digest = new String("098f6bcd4621d373cade4e832627b4f6");
    }

}
