package za.org.dragon.exodus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLStreamHandler;
import java.net.URL;
import java.net.URLConnection;
//import java.net.URLStreamHandler;
import java.net.UnknownServiceException;

public class ModelURLHandler extends URLStreamHandler{
   public static void setup(){
       String oldValue = System.getProperty("java.protocol.handler.pkgs");
       if( oldValue != null ){
           oldValue += "|";
       }
       else{
           oldValue = "";
       }
       System.getProperties().put("java.protocol.handler.pkgs",oldValue+"ee.net.protocol");
   }

   protected URLConnection openConnection(URL u) throws IOException{
       return new Connection(u);
   }

   private static class Connection extends URLConnection{
       Connection(URL u){
           super(u);
       }

       public void connect(){
       }

       public InputStream getInputStream() throws IOException{
           InputStream result = getClass().getClassLoader().getResourceAsStream(url.getFile());
           if( result == null ){
               System.err.println("Resource not found: "+url.getFile());
               throw new IOException("Resource not found: "+url.getFile());
           }
           return result;
       }

       public OutputStream getOutputStream() throws IOException{
           throw new UnknownServiceException("Output is not supported");
       }
   }
}

//--------------------- End of File ---------------------
//
//--------------------- File: TestHandler.java ----------
//
//package ee.net;
//
//import ee.net.protocol.image.Handler;
//
//import javax.swing.*;
//import javax.swing.text.html.HTMLEditorKit;
//
//public class TestHandler{
//   public static void main(String[] args){
//       Handler.setup();
//       JFrame frame = new JFrame();
//       JEditorPane htmlPane = new JEditorPane();
//       frame.getContentPane().add(htmlPane);
//       htmlPane.setEditorKit(new HTMLEditorKit());
//       htmlPane.setText(
//           "<html><head>Test custom URLStreamHandler</head>\n"
//          +"<body>\n"
//          +"<a href=http://www.experts.exchange.com>Reference to EE</a><p>\n"
//          +"<img src=http://www.experts-exchange.com/v3.0/images/LogoNewGoldSm32.gif><p>\n"
//          +"<img src=image:ee/net/Test.gif><p>\n"
//          +"</body></html>"
//       );
//       frame.pack();
//       frame.setVisible(true);
//   }
//}
//
//--------------------- End of File ---------------------
//
