/*
 * ConnectionDialog.java
 *
 * Created on March 6, 2003, 5:49 PM
 */

package za.org.dragon.exodus;

import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import java.util.Properties;
import java.util.Enumeration;

/**
 *
 * @author  rdawes
 */
public class OptionsDialog extends javax.swing.JDialog {

    private ExodusUI exodusui;
    private Exodus exodus;
    private ExodusPlugin[] plugins;
    private static ExodusConfig exodusConfig = null;
    
    /** Creates new form ConnectionDialog */
    public OptionsDialog(Exodus exodus, ExodusUI exodusui) {
        super(exodusui, true);
        this.exodus = exodus;
        this.exodusui = exodusui;
        if (exodusConfig == null) {
            exodusConfig = new ExodusConfig(exodus);
        }
        
        initComponents();
        configTabbedPane.add("Proxies", exodusConfig);
        this.plugins = exodus.getPlugins();
        for (int i=0; i < plugins.length; i++) {
            if (plugins[i] != null) {
                JPanel panel = plugins[i].createConfigInterface();
                if (panel != null) {
                    configTabbedPane.add(plugins[i].getPluginName(),panel);
                }
            }
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        configTabbedPane = new javax.swing.JTabbedPane();
        errorMessageLabel = new javax.swing.JLabel();
        cancelButton = new javax.swing.JButton();
        applyButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setName("Options");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(configTabbedPane, gridBagConstraints);

        errorMessageLabel.setForeground(new java.awt.Color(255, 0, 0));
        errorMessageLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(errorMessageLabel, gridBagConstraints);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(cancelButton, gridBagConstraints);

        applyButton.setText("Apply");
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(applyButton, gridBagConstraints);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(400, 300));
        setLocation((screenSize.width-400)/2,(screenSize.height-300)/2);
    }//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        this.closeDialog(new WindowEvent(this,WindowEvent.WINDOW_CLOSED));
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_applyButtonActionPerformed
        String error = exodusConfig.acceptConfig(false);
        if (error != null) {
           errorMessageLabel.setText("Exodus Config : " + error);
           return;
        }
        for (int i=0; i < plugins.length; i++) {
            if (plugins[i] != null) {
                error = plugins[i].acceptConfig(false);
                if (error != null) {
                    errorMessageLabel.setText(plugins[i].getPluginName() + " : " + error);
                    return;
                }
            }
        }
        error = exodusConfig.acceptConfig(true);
        if (error != null) {
           errorMessageLabel.setText("Error in acceptConfig(true) for Exodus Config : " + error);
           return;
        }
        for (int i=0; i < plugins.length; i++) {
            if (plugins[i] != null) {
                error = plugins[i].acceptConfig(true);
                if ( error != null) {
                    errorMessageLabel.setText("Error in acceptConfig(true) for " + plugins[i].getPluginName() + " : " + error);
                    return;
                }
            }
        }
        this.closeDialog(new WindowEvent(this,WindowEvent.WINDOW_CLOSED));
    }//GEN-LAST:event_applyButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel errorMessageLabel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTabbedPane configTabbedPane;
    private javax.swing.JButton applyButton;
    // End of variables declaration//GEN-END:variables
    
}
