package za.org.dragon.exodus;

import za.org.dragon.exodus.Model;
/*
 * $Id: Proxy.java,v 1.9 2003/06/02 21:09:17 rdawes Exp $
 */
import java.util.Properties;
import java.util.Enumeration;
import java.net.*;
import java.io.*;
import java.lang.NumberFormatException;
import java.util.logging.Logger;

public class Proxy implements Runnable {
    
    // Default properties for URLFetcher as well
    // We init them here, but maybe we should do it somewhere else?
    private boolean portChanged = false;
    
    private String listenHost = null;
    private int listenPort = 0;
    
    private Exodus exodus;
    private Model model;
    private ExodusPlugin[] plugins;
    private ServerSocket serversocket;
    private Logger logger = Logger.getLogger("za.org.exodus.Proxy");
    
    public Proxy(Exodus exodus) {
        this.exodus = exodus;
        this.model = exodus.getModel();
    }

    public void setPlugins(ExodusPlugin[] plugins) {
        this.plugins = plugins;
    }
    
    public void run() {
        Socket sock;

        while (true) {
            portChanged = false;
            serversocket = null;
            while (serversocket == null) {
                try {
                    InetAddress addr = null;
                    if (!listenHost.equals(""))
                        addr = InetAddress.getByName(listenHost);
                    logger.info("Listening on " + listenHost + ":" + listenPort);
                    serversocket = new ServerSocket(listenPort, 5, addr);
                } catch (Exception e) {
                    logger.severe("Could not bind to " + listenHost + ":" + listenPort + " : " + e);
                    logger.severe("sleeping for 5 seconds while you do something about it");
                    try {
                        Thread.currentThread().sleep(5000);
                    } catch (InterruptedException ie) {}
                }
            }
            try {
                serversocket.setSoTimeout(100);
            } catch (SocketException se) {
                logger.info("Error setting sockettimeout " + se);
            }
            logger.info("Proxy server started");
            while (! portChanged) {
                try {
                    sock = serversocket.accept();
                    logger.info("Connect from " + sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
                    new ConnectionHandler(model, plugins, sock);
                } catch (IOException e) {
                    if (!e.getMessage().equals("Accept timed out")) {
                        logger.severe("I/O error while waiting for a connection : " + e.getMessage());
                    }
                }
            }
            logger.info("ListenPort was changed. Closing and re-opening the socket");
            try {
                serversocket.close();
            } catch (IOException ioe) {
                logger.severe("Error closing the listen socket");
            }
        }
    }
    
    public void setListenPort(String server, int port) {
        if (port > 0 && port != this.listenPort || !server.equals(listenHost)) {
            this.listenPort = port;
            this.listenHost = server;
            this.portChanged = true;
        }
    }
    
    public String getListenServer() {
        return listenHost;
    }
    
    public int getListenPort() {
        return listenPort;
    }
}
