/*
 * Response.java
 *
 * Created on May 12, 2003, 11:18 PM
 */

package za.org.dragon.exodus;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.ByteArrayOutputStream;

/**
 *
 * @author  rdawes
 */
public class Response extends Message {
    
    private String version = null;
    private String status = null;
    private String message = null;
    InputStream is = null;
    
    /** Creates a new instance of Request */
    public Response() {
    }
    
    public Response(Response resp) {
        this.version = resp.getVersion();
        this.status = resp.getStatus();
        this.message = resp.getMessage();
        setHeaders(resp.getHeaders());
        setContent(resp.getContent());
    }
    
    public void read(InputStream is) throws IOException {
        String line = readLine(is);
        String[] parts = line.split(" ", 3);
        if (parts.length == 3) {
            setVersion(parts[0]);
            setStatus(parts[1]);
            setMessage(parts[2]);
        }
        super.read(is);
        if (status.startsWith("1") || status.equals("304") || status.equals("204")) {
            // These messages MUST NOT include a body
            setContentStream(null);
        }
    }
    
    public void write(OutputStream os) throws IOException {
        write(os, "\r\n");
    }
    
    public void write(OutputStream os, String crlf) throws IOException {
        os.write(new String(version + " " + getStatusLine() + crlf).getBytes());
        super.write(os,crlf);
    }
    
    public void setVersion(String version) {
        this.version = version;
    }
    
    public String getVersion() {
        return version;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    
    public String getStatus() {
        return status;
    }
    
    public void setMessage(String message) {
        this.message = message;
    }
    
    public String getMessage() {
        return message;
    }
    
    public String getStatusLine() {
        return status + " " + message;
    }
    
    public String toString() {
        return toString("\r\n");
    }
    
    public String toString(String crlf) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            write(baos, crlf);
        } catch (IOException ioe) {}
        return new String(baos.toByteArray());
    }
    
    public static void main(String args[]) {
        Response response = new Response();
        response.setVersion("HTTP/1.0");
        response.setStatus("200");
        response.setMessage("Ok");
        response.setHeader("Connection","keep-alive");
        System.out.println("response is '" + response.toString() + "'");
        
        try {
            java.io.FileInputStream fis = new java.io.FileInputStream("/mnt/data/temp/exodus/conversations/00002/fromserver");
            Response r2 = new Response();
            r2.read(fis);
            r2.write(System.out);
        } catch (java.io.FileNotFoundException fnfe) {
            System.out.println("File not found " + fnfe);
        } catch (IOException ioe) {
            System.out.println("IOException " + ioe);
        }
    }    
}
