/*
 * TranscoderFrame.java
 *
 * Created on 29 May 2003, 03:18
 */

package za.org.dragon.exodus;

import java.awt.datatransfer.*;
import javax.swing.undo.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import javax.swing.text.*;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.charset.*;
import java.security.*;
import java.security.cert.*;
import java.util.*;

import javax.crypto.*;
import javax.crypto.spec.*;

/**
 *
 * @author  rdawes
 */
public class TranscoderFrame extends javax.swing.JFrame implements ClipboardOwner {
    
    private Clipboard clipboard = getToolkit().getSystemClipboard();
    protected UndoManager undo = new UndoManager();
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    private Hashtable actions;
    
    private static sun.misc.BASE64Decoder decoder = new sun.misc.BASE64Decoder();
    private static sun.misc.BASE64Encoder encoder = new sun.misc.BASE64Encoder();
    
    /** Creates new form TranscoderFrame */
    public TranscoderFrame() {
        initComponents();
        createActionTable(textPane);

        undoAction = new UndoAction();
        editMenu.add(undoAction);
        redoAction = new RedoAction();
        editMenu.add(redoAction);
        
        editMenu.addSeparator();
 
        //These actions come from the default editor kit.
        //Get the ones we want and stick them in the menu.
        editMenu.add(getActionByName(DefaultEditorKit.cutAction));
        editMenu.add(getActionByName(DefaultEditorKit.copyAction));
        editMenu.add(getActionByName(DefaultEditorKit.pasteAction));
 
        editMenu.addSeparator();
 
        editMenu.add(getActionByName(DefaultEditorKit.selectAllAction));
         
        Document d = textPane.getDocument();
        d.addUndoableEditListener(new MyUndoableEditListener());
        
    }
    
    //The following two methods allow us to find an
    //action provided by the editor kit by its name.
    private void createActionTable(JTextComponent textComponent) {
        actions = new Hashtable();
        Action[] actionsArray = textComponent.getActions();
        for (int i = 0; i < actionsArray.length; i++) {
            Action a = actionsArray[i];
            actions.put(a.getValue(Action.NAME), a);
        }
    }
                                                                                
    private Action getActionByName(String name) {
        return (Action)(actions.get(name));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        textPane = new javax.swing.JTextPane();
        jPanel1 = new javax.swing.JPanel();
        urlEncodeButton = new javax.swing.JButton();
        urlDecodeButton = new javax.swing.JButton();
        base64EncodeButton = new javax.swing.JButton();
        base64DecodeButton = new javax.swing.JButton();
        md5hashButton = new javax.swing.JButton();
        sha1hashButton = new javax.swing.JButton();
        jMenuBar1 = new javax.swing.JMenuBar();
        editMenu = new javax.swing.JMenu();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Exodus Transcoder");
        jScrollPane1.setViewportView(textPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        urlEncodeButton.setText("URL encode");
        urlEncodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                urlEncodeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(urlEncodeButton, gridBagConstraints);

        urlDecodeButton.setText("URL decode");
        urlDecodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                urlDecodeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(urlDecodeButton, gridBagConstraints);

        base64EncodeButton.setText("Base64 encode");
        base64EncodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                base64EncodeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(base64EncodeButton, gridBagConstraints);

        base64DecodeButton.setText("Base64 decode");
        base64DecodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                base64DecodeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(base64DecodeButton, gridBagConstraints);

        md5hashButton.setText("MD5 hash");
        md5hashButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                md5hashButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(md5hashButton, gridBagConstraints);

        sha1hashButton.setText("SHA-1 hash");
        sha1hashButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sha1hashButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(sha1hashButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        editMenu.setText("Edit");
        jMenuBar1.add(editMenu);

        setJMenuBar(jMenuBar1);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(600, 400));
        setLocation((screenSize.width-600)/2,(screenSize.height-400)/2);
    }//GEN-END:initComponents
    
    private void sha1hashButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sha1hashButtonActionPerformed
        textPane.select(0,textPane.getText().length());
        textPane.replaceSelection(hashSHA(textPane.getText()));
    }//GEN-LAST:event_sha1hashButtonActionPerformed
    
    private void md5hashButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_md5hashButtonActionPerformed
        textPane.select(0,textPane.getText().length());
        textPane.replaceSelection(hashMD5(textPane.getText()));
    }//GEN-LAST:event_md5hashButtonActionPerformed
    
    private void base64DecodeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_base64DecodeButtonActionPerformed
        try {
            textPane.select(0,textPane.getText().length());
            textPane.replaceSelection(base64Decode(textPane.getText()));
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }//GEN-LAST:event_base64DecodeButtonActionPerformed
    
    private void urlDecodeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_urlDecodeButtonActionPerformed
        textPane.select(0,textPane.getText().length());
        textPane.replaceSelection(urlDecode(textPane.getText()));
    }//GEN-LAST:event_urlDecodeButtonActionPerformed
            
    private void urlEncodeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_urlEncodeButtonActionPerformed
        textPane.select(0,textPane.getText().length());
        textPane.replaceSelection(urlEncode(textPane.getText()));
    }//GEN-LAST:event_urlEncodeButtonActionPerformed
    
    private void base64EncodeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_base64EncodeButtonActionPerformed
        textPane.select(0,textPane.getText().length());
        textPane.replaceSelection(base64Encode(textPane.getText()));
    }//GEN-LAST:event_base64EncodeButtonActionPerformed
    
    /** Notifies this object that it is no longer the owner of
     * the contents of the clipboard.
     * @param clipboard the clipboard that is no longer owned
     * @param contents the contents which this owner had placed on the clipboard
     *
     */
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
    
    /**
     *  Returns the base 64 decoding of a string.
     *
     *@param  str              Description of the Parameter
     *@return                  Description of the Return Value
     *@exception  IOException  Description of the Exception
     */
    public static String base64Decode( String str )
    throws IOException {
        byte[] b = decoder.decodeBuffer( str );
        return ( new String( b ) );
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  c                Description of the Parameter
     *@return                  Description of the Return Value
     *@exception  IOException  Description of the Exception
     */
    public static String base64Decode( char[] c ) throws IOException {
        return base64Decode( new String( c ) );
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  c  Description of the Parameter
     *@return    Description of the Return Value
     */
    public static String base64Encode( char[] c ) {
        return base64Encode( new String( c ) );
    }
    
    
    /**
     *  Returns the base 64 encoding of a string.
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String base64Encode( String str ) {
        byte[] b = str.getBytes();
        return ( encoder.encode( b ) );
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  b  Description of the Parameter
     *@return    Description of the Return Value
     */
    public static String base64Encode( byte[] b ) {
        return ( encoder.encode( b ) );
    }
    
    /**
     *  Returns the MD5 hash of a String.
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String hashMD5( String str ) {
        byte[] b = str.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance( "MD5" );
            md.update( b );
        }
        catch ( NoSuchAlgorithmException e ) {
            e.printStackTrace();
            // it's got to be there
        }
        return ( hexEncode( md.digest() ) );
    }
    
    
    
    /**
     *  Returns the SHA hash of a String.
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String hashSHA( String str ) {
        byte[] b = str.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance( "SHA1" );
            md.update( b );
        }
        catch ( NoSuchAlgorithmException e ) {
            e.printStackTrace();
            // it's got to be there
        }
        return ( hexEncode( md.digest() ) );
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  hexString  Description of the Parameter
     *@return            Description of the Return Value
     */
    public static String hexDecode( String hexString ) {
        try {
            if ( ( hexString.length() % 2 ) != 0 ) {
                return ( "String not comprised of Hex digit pairs." );
            }
            char[] chars = new char[hexString.length()];
            char[] convChars = new char[hexString.length() / 2];
            hexString.getChars( 0, hexString.length(), chars, 0 );
            StringBuffer buff = new StringBuffer();
            for ( int i = 0; i < hexString.length(); i += 2 ) {
                String hexToken = new String( chars, i, 2 );
                convChars[i / 2] = (char) Integer.parseInt( hexToken, 16 );
            }
            return new String( convChars );
        }
        catch ( NumberFormatException nfe ) {
            return ( "String not comprised of Hex digits" );
        }
    }
    
    /**
     *  Description of the Method
     *
     *@param  asciiString  Description of the Parameter
     *@return              Description of the Return Value
     */
    public static String hexEncode( String asciiString ) {
        return hexEncode(asciiString.getBytes());
    }
    
    public static String hexEncode( byte[] data) {
        StringBuffer hexBuff = new StringBuffer();
        for (int i=0; i<data.length; i++) {
            String hex = Integer.toHexString(data[i] & 0x000000FF);
            if (hex.length() == 1) {
                hexBuff.append("0" + hex);
            } else {
                hexBuff.append( hex );
            }
        }
        return hexBuff.toString();
    }
    
    /**
     *  Description of the Method
     *
     *@param  input  Description of the Parameter
     *@return        Description of the Return Value
     */
    public static synchronized String rot13( String input ) {
        StringBuffer output = new StringBuffer();
        if ( input != null ) {
            for ( int i = 0; i < input.length(); i++ ) {
                char inChar = input.charAt( i );
                if ( ( inChar >= 'A' ) & ( inChar <= 'Z' ) ) {
                    inChar += 13;
                    if ( inChar > 'Z' ) {
                        inChar -= 26;
                    }
                }
                if ( ( inChar >= 'a' ) & ( inChar <= 'z' ) ) {
                    inChar += 13;
                    if ( inChar > 'z' ) {
                        inChar -= 26;
                    }
                }
                output.append( inChar );
            }
        }
        return output.toString();
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String unicodeDecode( String str ) {
        // FIXME: TOTALLY EXPERIMENTAL
        try {
            ByteBuffer bbuf = ByteBuffer.allocate( str.length() );
            bbuf.put( str.getBytes() );
            Charset charset = Charset.forName( "ISO-8859-1" );
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cbuf = decoder.decode( bbuf );
            return ( cbuf.toString() );
        }
        catch ( Exception e ) {
            return ( "Encoding problem" );
        }
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String unicodeEncode( String str ) {
        // FIXME: TOTALLY EXPERIMENTAL
        try {
            Charset charset = Charset.forName( "ISO-8859-1" );
            CharsetEncoder encoder = charset.newEncoder();
            ByteBuffer bbuf = encoder.encode( CharBuffer.wrap( str ) );
            return ( new String( bbuf.array() ) );
        }
        catch ( Exception e ) {
            return ( "Encoding problem" );
        }
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String urlDecode( String str ) {
        try {
            return ( URLDecoder.decode( str ) );
        }
        catch ( Exception e ) {
            return ( "Decoding error" );
        }
    }
    
    
    /**
     *  Description of the Method
     *
     *@param  str  Description of the Parameter
     *@return      Description of the Return Value
     */
    public static String urlEncode( String str ) {
        try {
            return ( URLEncoder.encode( str ) );
        }
        catch ( Exception e ) {
            return ( "Decoding error" );
        }
    }
    
    
    /** Exit the Application */
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        TranscoderFrame tf = new TranscoderFrame();
        tf.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                System.exit(0);
            }
        });
        tf.show();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton sha1hashButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton base64EncodeButton;
    private javax.swing.JButton md5hashButton;
    private javax.swing.JMenu editMenu;
    private javax.swing.JButton urlEncodeButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton base64DecodeButton;
    private javax.swing.JTextPane textPane;
    private javax.swing.JButton urlDecodeButton;
    private javax.swing.JMenuBar jMenuBar1;
    // End of variables declaration//GEN-END:variables
    
    class UndoAction extends AbstractAction {
        public UndoAction() {
            super("Undo");
            setEnabled(false);
        }
        
        public void actionPerformed(ActionEvent e) {
            try {
                undo.undo();
            } catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            updateUndoState();
            redoAction.updateRedoState();
        }
        
        protected void updateUndoState() {
            if (undo.canUndo()) {
                setEnabled(true);
                putValue(Action.NAME, undo.getUndoPresentationName());
            } else {
                setEnabled(false);
                putValue(Action.NAME, "Undo");
            }
        }
    }
    
    
    class RedoAction extends AbstractAction {
        public RedoAction() {
            super("Redo");
            setEnabled(false);
        }
        
        public void actionPerformed(ActionEvent e) {
            try {
                undo.redo();
            } catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            updateRedoState();
            undoAction.updateUndoState();
        }
        
        protected void updateRedoState() {
            if (undo.canRedo()) {
                setEnabled(true);
                putValue(Action.NAME, undo.getRedoPresentationName());
            } else {
                setEnabled(false);
                putValue(Action.NAME, "Redo");
            }
        }
    }
    
    
    //This one listens for edits that can be undone.
    protected class MyUndoableEditListener
    implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent e) {
            //Remember the edit and update the menus.
            undo.addEdit(e.getEdit());
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
    }
    
    
}
