/*
 * $Id: URLInfo.java,v 1.9 2003/06/02 21:13:07 rdawes Exp $
 * URLInfo.java
 *
 * Created on March 3, 2003, 12:23 PM
 */

package za.org.dragon.exodus;

import java.net.URL;
import java.net.MalformedURLException;
import java.lang.IllegalArgumentException;
//import java.util.Vector;
import java.util.Properties;

/**
 *
 * @author  rdawes
 */
public class URLInfo {
    
    private URL url;
    private Properties props;  // Contains all attributes of the URL
    
    /** Creates a new instance of URLInfo */
    public URLInfo(String url) throws MalformedURLException, IllegalArgumentException {
        this(new URL(url));
    }
    
    public URLInfo(URL url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("URLInfo's can't be initialised with a null URL");
        } else if (url.getQuery() != null) {
            throw new IllegalArgumentException("URLInfo's should not be initialised with URL's that contain a query component " + url);
        }
        this.url = url;
        this.props = new Properties();
    }
    
    public void setProperty(String key, String value) {
        synchronized (props) {
            if (value == null) {
                props.remove(key);
            } else {
                props.setProperty(key,value);
            }
        }
    }
    
    public void addProperty(String key, String value) {
        synchronized (props) {
            String current = getProperty(key);
            if (current == null) {
                setProperty(key,value);
            } else {
                int pos = current.indexOf(value);
                if ( pos == -1 ) {
                    setProperty(key,current + ", " + value);
                } else {
                    boolean present = false;
                    while (pos > -1 && !present) {
                        if (pos + value.length() == current.length() || current.substring(pos+value.length(),pos+value.length()+1).equals(",")) {
                            present = true;
                        }
                        pos = current.indexOf(value,pos+1);
                    }
                    if (!present) {
                        setProperty(key,current + ", " + value);
                    }
                }
            }
        }
    }
    
    public void setProperty(String key, Boolean value) {
        if (value == null) {
        } else if (value == Boolean.FALSE) {
            setProperty(key,"false");
        } else {
            setProperty(key,"true");
        }
    }
    
    public void setProperty(String key, String[] values) {
        String value = null;
        if (values != null && values.length > 0) {
            value = new String(values[0]);
            for (int i=1; i<values.length; i++) {
                value = value.concat(", " + values[i]);
            }
        }
        setProperty(key,value);
    }
    
    public String getProperty(String key) {
        synchronized (props) {
            return props.getProperty(key);
        }
    }
    
    public Boolean getPropertyAsBoolean(String key) {
        String value = getProperty(key);
        if (value == null) {
            return null;
        } else if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        } else if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
    
    public String[] getPropertyAsArray(String key) {
        String value = getProperty(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.split(", *");
    }
    
    public String getName() {
        if (url != null) {
            String[] elements = getURLElements();
            if (elements.length>0) {
                return elements[elements.length-1];
            }
        }
        return "";
    }
    
    public URL getURL() {
        return url;
    }
    
    /* This routine breaks an url up into the component pieces, string wise.
     * we keep the method://server:port/ part as one, then break up the path elements
     * into "/" terminated strings, and finally add the filename as the last one
     */
    
    public String[] getURLElements() {
        String url = this.url.toString();
        if (url.indexOf("/")<0 || url.indexOf("http") != 0) {
            return new String[] { url };
        }
        String bits[];
        url = url + " "; // We want to make sure that we know if the last char was a "/"
        // If it was, the last element will just be a blank space, which
        // we can them trim to represent "no filename"
        String[] elements = url.split("/");
        elements[elements.length-1] = elements[elements.length-1].trim();
        if (elements[elements.length-1].equals("")) {
            bits = new String[elements.length-3];
            bits[bits.length-1] = elements[elements.length-2] + "/";
        } else {
            bits = new String[elements.length-2];
            bits[bits.length-1] = elements[elements.length-1];
        }
        bits[0] = elements[0] + "//" + elements[2] + "/";
        for (int i=3; i<elements.length-1; i++) {
            bits[i-2] = elements[i] + "/";
        }
        return bits;
    }
    
    public String toString() {
        if (url != null) {
            return getName();
        }
        return "";
    }
    
    public static void main(String[] args) {
        URLInfo u1 = null;
        URLInfo u2 = null;
        URLInfo u3 = null;
        try {
            u1 = new URLInfo("http://localhost:8080/admin");
            u2 = new URLInfo("http://localhost:8080/admin/");
            u3 = new URLInfo("http://localhost:8080/examples/example1/example2");
        } catch (MalformedURLException mue) {
            System.out.println("Error creating the Info's : " + mue);
            System.exit(1);
        } catch (IllegalArgumentException iae) {
            System.out.println("Illegal argument " + iae);
            System.exit(1);
        }
        System.out.println("1: " + u1.getURLElements()[u1.getURLElements().length-1]);
        System.out.println("1: " + u1.getName());
        System.out.println("1: " + u1.toString());
        System.out.println("2: " + u2.getURLElements()[u2.getURLElements().length-1]);
        System.out.println("3: " + u3.getURLElements()[u3.getURLElements().length-1]);
        
        u1.addProperty("Signature","GET;QUERY:userid;QUERY:password");
        u1.addProperty("Signature","GET;QUERY:userid");
        u1.addProperty("Signature","GET;QUERY:userid");
        u1.addProperty("Signature","GET;QUERY:userid;QUERY:password");
        System.out.println(u1.getProperty("Signature"));
    }
    
    
}
