/*
 * URLLogger.java
 *
 * Created on June 1, 2003, 7:20 PM
 */

package za.org.dragon.exodus;
import java.io.InputStream;

/**
 *
 * @author  rdawes
 */
public class URLLogger implements URLFilter {
    
    URLFilter uf;
    boolean logAlways;
    Request copyRequest = null;
    Response copyResponse = null;
    boolean requestAltered = false;
    boolean responseAltered = false;
    
    /** Creates a new instance of URLLogger */
    public URLLogger(URLFilter uf, boolean logAlways) {
        this.uf = uf;
        this.logAlways = logAlways;
    }
    
    public Response fetchResponse(Request request) {
        copyRequest = new Request();
        copyRequest.setMethod(request.getMethod());
        copyRequest.setURL(request.getURL());
        copyRequest.setVersion(request.getVersion());
        copyRequest.setHeaders(request.getHeaders());
        InputStream is = request.getContentStream();
        if (is != null) {
            is = new CopyInputStream(is);
        }
        request.setContentStream(is);
        copyRequest.setContentStream(is);
        
        Response response = uf.fetchResponse(request);
        
        if (response != null) {
            copyResponse = new Response();
            copyResponse.setVersion(response.getVersion());
            copyResponse.setStatus(response.getStatus());
            copyResponse.setMessage(response.getMessage());
            copyResponse.setHeaders(response.getHeaders());
            is = response.getContentStream();
            if (is != null) {
                is = new CopyInputStream(is);
            }
            response.setContentStream(is);
            copyResponse.setContentStream(is);
        }
        return response;
    }
    
    public Request getRequest() {
        if (logAlways || uf.requestChanged()) {
            return copyRequest;
        } else {
            return null;
        }
    }
    
    public Response getResponse() {
        if (logAlways || uf.responseChanged()) {
            return copyResponse;
        } else {
            return null;
        }
    }
    
    public boolean requestChanged() {
        if ( ! logAlways ) {
            return uf.requestChanged();
        } else {
            return false;
        }
    }
    
    public boolean responseChanged() {
        if ( ! logAlways ) {
            return uf.responseChanged();
        } else {
            return false;
        }
    }
}
