package za.org.dragon.exodus;

/** An URLNode is a container for the URLInfo class, useful for describing tree 
 * structures. In this case, we expect that it will be used to represent the 
 * site layout of the various URLs that we have seen and visited.
 */
import javax.swing.tree.TreeNode;
import java.util.Enumeration;
import java.net.MalformedURLException;

public class URLNode implements TreeNode {
    
    /** URL the receiver represents.  */
    private URLInfo ui;
    
    /** Parent FileNode of the receiver.  */
    private URLNode parent;
    
    /** Children of the receiver.  */
    private URLNode[] children;
    
    public URLNode(URLInfo ui) {
        this(null, ui);
    }
    
    public URLNode(URLNode parent, URLInfo ui) {
        this.parent = parent;
        this.ui = ui;
    }
    
    /** Returns the the string to be used to display this leaf in the JTree.
     *
     */
    public String toString() {
        if (ui != null) {
            return ui.getName();
        } else {
            return "null";
        }
    }
    
    /** Returns the URLInfo that this node represents.
     *
     */
    public URLInfo getInfo() {
        if (ui != null) {
            return ui;
        }
        try {
            return new URLInfo("");
        } catch (MalformedURLException mue) {
            return null;
        }
    }
    
    public void setInfo(URLInfo ui) {
        this.ui = ui;
    }
    
    /** Returns the parent of the receiver.
     *
     */
    public TreeNode getParent() {
        return parent;
    }
    
    /** Returns true if the receiver represents a leaf, that is it is
     * isn't a directory.
     *
     */
    public boolean isLeaf() {
        if (ui != null) {
            return !ui.toString().endsWith("/");
        }
        return false;
        //	    return ui.isFile();
    }
    
    /** Loads the children, caching the results in the children
     * instance variable.
     *
     */
    public URLNode[] getChildren() {
        return children;
    }
    
    /** Gets the path from the root to the receiver.
     *
     */
    public URLNode[] getPath() {
        return getPathToRoot(this, 0);
    }
    
    /** Returns the canonical path for the receiver.
     *
     */
    public String getCanonicalPath() {
        if (ui!=null) {
            return ui.toString();
        }
        return "";
    }
    
    public URLNode[] getPathToRoot(URLNode aNode, int depth) {
        URLNode[]              retNodes;
        
        if(aNode == null) {
            if(depth == 0)
                return null;
            else
                retNodes = new URLNode[depth];
        }
        else {
            depth++;
            retNodes = getPathToRoot((URLNode)aNode.getParent(), depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }
    
    /** Sets the children of the receiver,
     * and if generateEvent is true a tree structure changed event
     * is created.
     *
     */
    public void setChildren(URLNode[] newChildren) {
        children = newChildren;
    }
    
    /** Returns the children of the receiver as an <code>Enumeration</code>.
     *
     */
    public Enumeration children() {
        return null;
    }
    
    /** Returns true if the receiver allows children.
     *
     */
    public boolean getAllowsChildren() {
        return true;
    }
    
    /** Returns the child <code>TreeNode</code> at index
     * <code>childIndex</code>.
     *
     */
    public TreeNode getChildAt(int childIndex) {
        return null;
    }
    
    /** Returns the number of children <code>TreeNode</code>s the receiver
     * contains.
     *
     */
    public int getChildCount() {
        if (children != null) {
            return children.length;
        }
        return 0;
    }
    
    /** Returns the index of <code>node</code> in the receivers children.
     * If the receiver does not contain <code>node</code>, -1 will be
     * returned.
     *
     */
    public int getIndex(TreeNode node) {
        return -1;
    }
    
}

