/*
 * $Id: LogView.java,v 1.9 2003/06/05 06:48:08 rdawes Exp $
 * LogView.java
 *
 * Created on February 17, 2003, 9:07 PM
 */

package za.org.dragon.exodus.plugins.ConversationLog;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;

import za.org.dragon.exodus.Model;
import za.org.dragon.exodus.MessageLog;
import za.org.dragon.exodus.Request;
import za.org.dragon.exodus.Response;
import za.org.dragon.exodus.Util;
import za.org.dragon.exodus.RequestPanel;
import za.org.dragon.exodus.ResponsePanel;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
//import javax.swing.event.TableModelEvent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

//import java.io.IOException;

import java.util.logging.Logger;

/**
 *
 * @author  rdawes
 */
public class LogView extends javax.swing.JPanel {

    Model _model = null;
    Logger _logger = Logger.getLogger("za.org.dragon.exodus.plugins.ConversationPlugin");
    String conversationID = null;
    
    /** Creates new form LogView */
    public LogView(Model model) {
        _model = model;
        initComponents();
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;

        clientRequestPanel = new RequestPanel(null);
        clientRequestPanel.setBorder(new TitledBorder("From client"));
        clientRequestPanel.setVisible(false);
        requestPanel.add(clientRequestPanel,gridBagConstraints);
        gridBagConstraints.gridx = 1;
        serverRequestPanel = new RequestPanel(null);
        serverRequestPanel.setBorder(new TitledBorder("To server"));
        requestPanel.add(serverRequestPanel,gridBagConstraints);

        serverResponsePanel = new ResponsePanel(null);
        serverResponsePanel.setBorder(new TitledBorder("From server"));
        gridBagConstraints.gridx = 0;
        responsePanel.add(serverResponsePanel,gridBagConstraints);
        clientResponsePanel = new ResponsePanel(null);
        clientResponsePanel.setBorder(new TitledBorder("To client"));
        clientResponsePanel.setVisible(false);
        gridBagConstraints.gridx = 1;
        responsePanel.add(clientResponsePanel,gridBagConstraints);
    }

    public void clearSession() {
        conversationID = null;
        clientRequestPanel.setRequest(null);
        serverRequestPanel.setRequest(null);
        serverResponsePanel.setResponse(null);
        clientResponsePanel.setResponse(null);
        conversationDescriptionTextField.setText("");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        requestButtonGroup = new javax.swing.ButtonGroup();
        responseButtonGroup = new javax.swing.ButtonGroup();
        logViewSplitPane = new javax.swing.JSplitPane();
        logPanel = new javax.swing.JPanel();
        logTableScrollPane = new javax.swing.JScrollPane();
        logTable = new javax.swing.JTable();
        logTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        ListSelectionModel rowSM = logTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                logTableValueChanged(e);
            }
        });

        jLabel5 = new javax.swing.JLabel();
        conversationDescriptionTextField = new javax.swing.JTextField();
        jSplitPane1 = new javax.swing.JSplitPane();
        requestPanel = new javax.swing.JPanel();
        responsePanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        logViewSplitPane.setBorder(null);
        logViewSplitPane.setDividerLocation(100);
        logViewSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        logViewSplitPane.setResizeWeight(0.3);
        logViewSplitPane.setName("Log");
        logViewSplitPane.setOneTouchExpandable(true);
        logViewSplitPane.setAutoscrolls(true);
        logPanel.setLayout(new java.awt.GridBagLayout());

        logTableScrollPane.setMinimumSize(null);
        logTableScrollPane.setPreferredSize(null);
        logTableScrollPane.setAutoscrolls(true);
        logTable.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        logTable.setModel(_model.getConversationTableModel());
        logTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        logTable.setMaximumSize(new java.awt.Dimension(2147483647, 32767));
        logTable.setMinimumSize(null);
        logTable.setPreferredScrollableViewportSize(null);
        logTable.setPreferredSize(null);
        logTable.setOpaque(false);
        logTableScrollPane.setViewportView(logTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        logPanel.add(logTableScrollPane, gridBagConstraints);

        jLabel5.setText("Description");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        logPanel.add(jLabel5, gridBagConstraints);

        conversationDescriptionTextField.setToolTipText("");
        conversationDescriptionTextField.setMinimumSize(new java.awt.Dimension(4, 20));
        conversationDescriptionTextField.setPreferredSize(new java.awt.Dimension(4, 20));
        conversationDescriptionTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                conversationDescriptionTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        logPanel.add(conversationDescriptionTextField, gridBagConstraints);

        logViewSplitPane.setTopComponent(logPanel);

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setOneTouchExpandable(true);
        requestPanel.setLayout(new java.awt.GridBagLayout());

        jSplitPane1.setLeftComponent(requestPanel);

        responsePanel.setLayout(new java.awt.GridBagLayout());

        jSplitPane1.setRightComponent(responsePanel);

        logViewSplitPane.setRightComponent(jSplitPane1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(logViewSplitPane, gridBagConstraints);

    }//GEN-END:initComponents

    private void conversationDescriptionTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_conversationDescriptionTextFieldActionPerformed
        updateDescription();
    }//GEN-LAST:event_conversationDescriptionTextFieldActionPerformed

    private void updateDescription() {
        if (conversationID != null) {
            String description = conversationDescriptionTextField.getText().trim();
            if (!description.equals(_model.getDescription(conversationID))) {
                _model.setDescription(conversationID,description);
            }
        }
    }
    
    private void logTableValueChanged(ListSelectionEvent e) {
        //Ignore extra messages.
        if (e.getValueIsAdjusting()) return;

        updateDescription();
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            conversationID = null;
            conversationDescriptionTextField.setText("");
            clientRequestPanel.setVisible(false);
            serverRequestPanel.setVisible(false);
            serverResponsePanel.setVisible(false);
            clientResponsePanel.setVisible(false);
        } else {
            int row = lsm.getMinSelectionIndex();
            conversationID = (String)logTable.getValueAt(row, 0);
            Request fc = _model.getClientRequest(conversationID);
            if (fc !=null) clientRequestPanel.setRequest(fc);
            clientRequestPanel.setVisible(fc != null);
            Request ts = _model.getServerRequest(conversationID);
            if (ts != null) serverRequestPanel.setRequest(ts);
            serverRequestPanel.setVisible(ts != null);
            Response fs = _model.getServerResponse(conversationID);
            if (fs != null) serverResponsePanel.setResponse(fs);
            serverResponsePanel.setVisible(fs != null);
            Response tc = _model.getClientResponse(conversationID);
            if (tc != null) clientResponsePanel.setResponse(tc);
            clientResponsePanel.setVisible(tc != null);
            String desc = _model.getDescription(conversationID);
            conversationDescriptionTextField.setText(desc);
        }
    }
        
    private RequestPanel clientRequestPanel;
    private RequestPanel serverRequestPanel;
    private ResponsePanel serverResponsePanel;
    private ResponsePanel clientResponsePanel;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel responsePanel;
    private javax.swing.ButtonGroup requestButtonGroup;
    private javax.swing.JScrollPane logTableScrollPane;
    private javax.swing.JPanel requestPanel;
    private javax.swing.JTextField conversationDescriptionTextField;
    private javax.swing.JSplitPane logViewSplitPane;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JPanel logPanel;
    private javax.swing.JTable logTable;
    private javax.swing.ButtonGroup responseButtonGroup;
    private javax.swing.JLabel jLabel5;
    // End of variables declaration//GEN-END:variables
    
}