/*
 * ConversationPlugin.java
 *
 * Created on March 29, 2003, 10:31 AM
 */

package za.org.dragon.exodus.plugins.Fuzzer;

import java.lang.Runnable;

import za.org.dragon.exodus.*;
import java.util.Vector;
import java.util.ArrayList;

import java.util.Properties;
import java.util.Enumeration;

/**
 *
 * @author  rdawes
 */
public class FuzzerPlugin extends za.org.dragon.exodus.NullPlugin {
    
    private Exodus _exodus;
    private FuzzerUI _ui = null;
    private FuzzerConfig _config = null;
    private int threads = 4;

    private Properties _props = new Properties();
    
    /** Creates a new instance of SpiderPlugin */
    public FuzzerPlugin() {
    }
    
    public void init(Exodus exodus) {
        _exodus = exodus;
        _props.setProperty("FuzzerPlugin.threads", "4");
        _props.setProperty("FuzzerPlugin.fuzzstrings", "/fuzzstrings");
        _props.setProperty("FuzzerPlugin.version","HTTP/1.1");
        configure(_props);
    }
    
    public void setProperties(Properties properties) {
        // This just allows us to copy our defaults over into
        // the main properties class, if they are not set already
        Enumeration propnames = _props.keys();
        while (propnames.hasMoreElements()) {
            String key = (String) propnames.nextElement();
            String value = properties.getProperty(key);
            System.out.println("Considering " + key);
            if (value == null) {
                properties.setProperty(key,_props.getProperty(key));
            }
        }
        _props = properties;
        configure(properties);
    }
    
    public String getPluginName() {
        return new String("URL Fuzzer");
    }

    private void configure(Properties properties) {
        if (_ui != null) {
            _ui.configure(properties);
        }
    }
    
    public javax.swing.JPanel createMainInterface() {
        if (_ui == null) {
            _ui = new FuzzerUI(_exodus.getModel());
            _ui.configure(_props);
        }
        return _ui;
    }
    
    public javax.swing.JPanel createConfigInterface() {
        _config = new FuzzerConfig(_exodus);
        return _config;
    }
    
    public String acceptConfig(boolean commit) {
        if (_config != null) {
            return _config.acceptConfig(commit);
        }
        return "";
    }
    
}