/*
 * FuzzerUI.java
 *
 * Created on May 6, 2003, 7:43 PM
 */

package za.org.dragon.exodus.plugins.Fuzzer;

import java.util.Observer;
import java.util.Observable;
import java.util.ArrayList;
import java.net.URL;
import java.net.MalformedURLException;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;

import javax.swing.table.DefaultTableModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.SwingUtilities;

import java.util.Vector;

import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.tree.TreeModel;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.JComboBox;
import javax.swing.DefaultCellEditor;

import javax.swing.table.TableModel;
import javax.swing.event.TableModelListener;
import javax.swing.event.TableModelEvent;

import java.util.TreeMap;
import java.util.Map;
import java.util.Collections;

import java.util.Properties;
import java.util.Enumeration;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import java.io.FileNotFoundException;
import java.io.IOException;

import za.org.dragon.exodus.*;

/**
 *
 * @author  rdawes
 */
public class FuzzerUI extends javax.swing.JPanel {
    
    Model model;
    TreeModel webtree;
    int threads = 4;
    URLFetcher[] uf;
    URLInfo selected;
    String[] signatures = null;
    TableModel ctm = null;
    ParameterTableModel ptm = new ParameterTableModel();
    Map values = Collections.synchronizedMap(new TreeMap());
    Request requestTemplate;
    String[] fuzzstrings = null;

    private boolean _haltFetchers = false;
    private FuzzerUI.Fetcher[] _fetcher = null;
    private FuzzerUI.RequestEnumeration _re = null;

    private String _version = null;
    
    /** Creates new form FuzzerUI */
    public FuzzerUI(Model model) {
        this.model = model;
        initComponents();
        
        ctm = model.getConversationTableModel();
        ctm.addTableModelListener(new TableModelListener() {
            public void tableChanged(TableModelEvent e) {
                conversationTableChanged(e);
            }
        });
        
        webtree = model.getSiteTreeModel();
        siteTree.setModel(webtree);
        siteTree.getSelectionModel().setSelectionMode
        (TreeSelectionModel.SINGLE_TREE_SELECTION);
        siteTree.setRootVisible(false);
        siteTree.setShowsRootHandles(true);
        
        //Listen for when the selection changes.
        siteTree.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                siteTree.getLastSelectedPathComponent();
                if (node == null) {
                    selected = null;
                } else {
                    selected = (URLInfo)node.getUserObject();
                }
                showSignatures(selected);
            }
        });
        siteTree.setCellRenderer(new ParamRenderer());
        
        signatureTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) return;
                int row = signatureTable.getSelectedRow();
                signatureTableValueChanged(row);
            }
        });
        paramTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) return;
                int row = paramTable.getSelectedRow();
                paramTableValueChanged(row);
            }
        });
        paramTable.setModel(ptm);
    }
    
    private String[] loadFuzz(String filename) throws IOException, FileNotFoundException {
        System.out.println("Reading from " + filename);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
        ArrayList fuzz = new ArrayList();
        String line;
        while ((line = in.readLine()) != null) {
            fuzz.add(line);
        }
        return  (String[])fuzz.toArray(new String[0]);
    }
    
    private void conversationTableChanged(TableModelEvent e) {
        // We just look for parameter values, and add them to the list
        if (e.getType() == e.INSERT || e.getType() == e.UPDATE && e.getFirstRow() <= ctm.getRowCount()-1) {
            String origin = (String) ctm.getValueAt(e.getFirstRow(), Model.ConversationTableModel.ORIGIN);
            if (origin == null || !(origin.equalsIgnoreCase("proxy") || origin.equalsIgnoreCase("Manual Request")) ) {
                return;
            }
            String query = (String) ctm.getValueAt(e.getFirstRow(), Model.ConversationTableModel.QUERY);
            String cookie = (String) ctm.getValueAt(e.getFirstRow(), Model.ConversationTableModel.COOKIE);
            String content = (String) ctm.getValueAt(e.getFirstRow(), Model.ConversationTableModel.CONTENT);
            String[] frags = null;
            String[] queries = null;
            if (query != null && query.startsWith(";")) {
                String[] pq = query.split("\\?",2);
                frags = pq[0].substring(1).split(";");
                if (pq.length>1) {
                    queries = pq[1].split("\\&");
                }
            } else if (query != null && query.startsWith("?")) {
                queries = query.substring(1).split("&");
            }
            if (frags != null && frags.length>0) {
                for (int i=0; i< frags.length; i++) {
                    if (frags[i].length() > 0) {
                        String[] pair = frags[i].split("=");
                        String sig = "FRAGMENT:" + pair[0];
                        ArrayList al = (ArrayList) values.get(sig);
                        if (al == null) {
                            al = new ArrayList(1);
                            values.put(sig,al);
                        }
                        if (!al.contains(pair[1])) {
                            al.add(pair[1]);
                        }
                    }
                }
            }
            if (queries != null && queries.length > 0) {
                for (int i=0; i<queries.length; i++) {
                    String[] pair = queries[i].split("=");
                    if (pair.length == 2) {
                        String sig = "QUERY:" + pair[0];
                        ArrayList al = (ArrayList) values.get(sig);
                        if (al == null) {
                            al = new ArrayList(1);
                            values.put(sig,al);
                        }
                        if (!al.contains(pair[1])) {
                            al.add(pair[1]);
                        }
                    }
                }
            }
            if (cookie != null) {
                // Add the cookie
                String[] cookies = cookie.split(" *; *");
                for (int i=0; i<cookies.length; i++) {
                    String[] pair = cookies[i].split("=");
                    String sig = "COOKIE:" + pair[0];
                    ArrayList al = (ArrayList) values.get(sig);
                    if (al == null) {
                        al = new ArrayList(1);
                        values.put(sig,al);
                    }
                    if (!al.contains(pair[1])) {
                        al.add(pair[1]);
                    }
                }
            }
            if (content != null) {
                // Add the body parameters
                String[] body = content.split("&");
                for (int i=0; i< body.length; i++) {
                    String[] pair = body[i].split("=");
                    if (pair.length == 2) {
                        String sig = "BODY:" + pair[0];
                        ArrayList al = (ArrayList) values.get(sig);
                        if (al == null) {
                            al = new ArrayList(1);
                            values.put(sig,al);
                        }
                        if (!al.contains(pair[1])) {
                            al.add(pair[1]);
                        }
                    }
                }
            }
        }
    }
    
    private void signatureTableValueChanged(int row) {
        ptm.clear();
        if (row == -1) {
            return;
        }
        
        Object[][] params = null;
        for (int column = signatureTable.getColumnCount()-1; column > 0; column--) {
            Object val = signatureTable.getValueAt(row,column);
            if (val != null && !((String) val).equals("")) {
                if (params == null)
                    params = new String[column][4];
                String[] pair = ((String) val).split(":");
                params[column-1][0] = pair[0];
                params[column-1][1] = pair[1];
                ArrayList al = (ArrayList) values.get(val);
                if (al != null) {
                    params[column-1][2] = al.get(0);
                    params[column-1][3] = params[column-1][2];
                }
            }
        }
        ptm.init(params);
    }
    
    private void paramTableValueChanged(int row) {
        if (row == -1) return;
        TableColumn paramColumn = paramTable.getColumnModel().getColumn(2);
        JComboBox comboBox = new JComboBox();
        String sig = ptm.getValueAt(row, 0) + ":" + ptm.getValueAt(row, 1);
        ArrayList al = (ArrayList) values.get(sig);
        if (al != null) {
            for (int i=0; i< al.size(); i++) {
                comboBox.addItem((String)al.get(i));
            }
        }
        paramColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }
    
    private void log(String message) {
        message = "FuzzerUI : " + message;
        System.out.println(message);
    }
    
    private synchronized void updateStatus(final String message) {
        SwingWorker sw = new SwingWorker() {
            public Object construct() { return null; }
            
            public void finished() {
//                synchronized(logTextArea) {
//                    logTextArea.append(message + "\n");
//                    logTextArea.setCaretPosition(logTextArea.getText().length());
//                }
                
                if (_haltFetchers && _re.hasMoreElements()) {
                    resumeButton.setEnabled(true);
                }
                if (!_re.hasMoreElements() || _haltFetchers) {
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                }
            }
        };
        sw.start();
    }

    public void configure(Properties props) {
        String prop = "FuzzerPlugin.threads";
        String threadString = props.getProperty(prop);
        try {
            threads = Integer.parseInt(props.getProperty(prop));
        } catch (NumberFormatException nfe) {
            System.out.println("Error parsing " + prop + " from properties");
        }
        
        prop = "FuzzerPlugin.fuzzstrings";
        try {
            fuzzstrings = loadFuzz(props.getProperty(prop));
        } catch (Exception e) {
            System.out.println("Error parsing " + prop + " from properties " + e);
        }
        
        prop = "FuzzerPlugin.version";
        _version = props.getProperty(prop);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        URLTreeScrollPane = new javax.swing.JScrollPane();
        siteTree = new javax.swing.JTree();
        jLabel3 = new javax.swing.JLabel();
        SignatureScrollPane = new javax.swing.JScrollPane();
        signatureTable = new javax.swing.JTable();
        jLabel4 = new javax.swing.JLabel();
        paramScrollPane = new javax.swing.JScrollPane();
        paramTable = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        deleteHeaderButton = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        newHeaderButton = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        headerTable = new javax.swing.JTable();
        startButton = new javax.swing.JButton();
        stopButton = new javax.swing.JButton();
        resumeButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Site Tree");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel1, gridBagConstraints);

        URLTreeScrollPane.setViewportView(siteTree);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(URLTreeScrollPane, gridBagConstraints);

        jLabel3.setText("Parameter signatures");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel3, gridBagConstraints);

        signatureTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        signatureTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        SignatureScrollPane.setViewportView(signatureTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        add(SignatureScrollPane, gridBagConstraints);

        jLabel4.setText("Parameters");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel4, gridBagConstraints);

        paramTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        paramTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        paramScrollPane.setViewportView(paramTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(paramScrollPane, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        deleteHeaderButton.setText("Delete");
        deleteHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteHeaderButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 0.0010;
        jPanel1.add(deleteHeaderButton, gridBagConstraints);

        jLabel2.setText("Request Headers");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel2, gridBagConstraints);

        newHeaderButton.setText("Add");
        newHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newHeaderButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weighty = 0.0010;
        jPanel1.add(newHeaderButton, gridBagConstraints);

        jScrollPane3.setMaximumSize(new java.awt.Dimension(32767, 100));
        jScrollPane3.setMinimumSize(new java.awt.Dimension(22, 40));
        jScrollPane3.setPreferredSize(new java.awt.Dimension(453, 150));
        headerTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Value"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        headerTable.setPreferredScrollableViewportSize(new java.awt.Dimension(450, 300));
        headerTable.setPreferredSize(null);
        jScrollPane3.setViewportView(headerTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jScrollPane3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        add(jPanel1, gridBagConstraints);

        startButton.setText("Start");
        startButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        add(startButton, gridBagConstraints);

        stopButton.setText("Stop");
        stopButton.setEnabled(false);
        stopButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        add(stopButton, gridBagConstraints);

        resumeButton.setText("Continue");
        resumeButton.setEnabled(false);
        resumeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resumeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(resumeButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void resumeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resumeButtonActionPerformed
        if (_re!=null && _re.hasMoreElements())
            fuzz();
    }//GEN-LAST:event_resumeButtonActionPerformed
    
    private void stopButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopButtonActionPerformed
        _haltFetchers = true;
        for (int i=0; i<threads; i++) {
            if (_fetcher[i] != null) {
                _fetcher[i].stop();
                _fetcher[i] = null;
            }
        }
        startButton.setEnabled(true);
        stopButton.setEnabled(false);
        if (_re != null && _re.hasMoreElements()) 
            resumeButton.setEnabled(true);
    }//GEN-LAST:event_stopButtonActionPerformed

    private String[][] getHeaders() {
        String[][] header = new String[headerTable.getModel().getRowCount()][2];
        for (int i = 0; i<headerTable.getModel().getRowCount(); i++) {
            header[i][0] = (String)headerTable.getModel().getValueAt(i, 0);
            header[i][1] = (String)headerTable.getModel().getValueAt(i, 1);
        }
        return header;
    }
    
    private void startButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startButtonActionPerformed
        if (ptm.getData().length == 0) {
            log("No parameters selected");
            return;
        }
        String method = (String) signatureTable.getModel().getValueAt(signatureTable.getSelectedRow(), 0);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) siteTree.getLastSelectedPathComponent();
        if (node == null) return;
        URL url = ((URLInfo) node.getUserObject()).getURL();
        Object[][] params = ptm.getData();
        String[][] headers = getHeaders();
        _re = new FuzzerUI.RequestEnumeration(method, url, params, headers, fuzzstrings);
        fuzz();
    }//GEN-LAST:event_startButtonActionPerformed
    
    private void fuzz() {
        startButton.setEnabled(false);
        resumeButton.setEnabled(false);
        stopButton.setEnabled(true);

        _haltFetchers = false;

        if (_fetcher == null || _fetcher.length < threads) {
            _fetcher = new Fetcher[threads];
        }
        for (int i=0; i<threads; i++) {
            if (_fetcher[i] != null) {
                _fetcher[i].stop();
                _fetcher[i] = null;
            }
            if (_re.hasMoreElements()) {
                _fetcher[i] = new Fetcher(_re);
                new Thread(_fetcher[i]).start();
            }
        }
    }
    
    private void deleteHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteHeaderButtonActionPerformed
        System.out.println("Delete " + evt);
        if (headerTable.getSelectedRow()>-1) {
            ((DefaultTableModel)headerTable.getModel()).removeRow(headerTable.getSelectedRow());
        }
    }//GEN-LAST:event_deleteHeaderButtonActionPerformed
    
    private void newHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newHeaderButtonActionPerformed
        System.out.println("Add " + evt);
        if (headerTable.getSelectedRow()>-1) {
            ((DefaultTableModel)headerTable.getModel()).insertRow(headerTable.getSelectedRow()+1,new Object[] { null, null} );
        } else {
            ((DefaultTableModel)headerTable.getModel()).addRow(new Object[] {null,null});
        }
    }//GEN-LAST:event_newHeaderButtonActionPerformed
    
    private void showSignatures(URLInfo selected) {
        if (selected == null) {
            signatureTable.setModel(new DefaultTableModel(0,0));
        } else {
            signatures = selected.getPropertyAsArray("parameters");
            if (signatures == null) {
                signatureTable.setModel(new DefaultTableModel(0,0));
                return;
            }
            int maxparams=0;
            for (int i=0; i<signatures.length; i++) {
                int numparams = signatures[i].split(";").length;
                if (numparams > maxparams)
                    maxparams = numparams;
            }
            String[][] data = new String[signatures.length][maxparams];
            for (int i=0; i<signatures.length; i++) {
                log("i = " + i + " sig is '" + this.signatures[i] + "'");
                data[i] = signatures[i].split(";");
            }
            String[] columns = new String[maxparams];
            for (int i=1; i<maxparams; i++)
                columns[i] = new String("Parameter");
            columns[0] = "Request Method";
            signatureTable.setModel(new DefaultTableModel(data, columns));
            if (data.length > 0) {
                signatureTable.getSelectionModel().setSelectionInterval(0,0);
            }
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel4;
    private javax.swing.JScrollPane paramScrollPane;
    private javax.swing.JButton deleteHeaderButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTable paramTable;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton stopButton;
    private javax.swing.JTable headerTable;
    private javax.swing.JButton resumeButton;
    private javax.swing.JButton startButton;
    private javax.swing.JButton newHeaderButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTree siteTree;
    private javax.swing.JScrollPane URLTreeScrollPane;
    private javax.swing.JTable signatureTable;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane SignatureScrollPane;
    // End of variables declaration//GEN-END:variables
    
    class ParamRenderer extends DefaultTreeCellRenderer {
        
        public ParamRenderer() {
            //        tutorialIcon = new ImageIcon("images/middle.gif");
        }
        
        public Component getTreeCellRendererComponent(
        JTree tree,
        Object value,
        boolean sel,
        boolean expanded,
        boolean leaf,
        int row,
        boolean hasFocus) {
            
            super.getTreeCellRendererComponent(
            tree, value, sel,
            expanded, leaf, row,
            hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
            URLInfo ui = (URLInfo) node.getUserObject();
            if (ui != null && ! hasFocus) {
                String[] params = ui.getPropertyAsArray("parameters");
                String seen = ui.getProperty("conversations");
                Boolean cookie = ui.getPropertyAsBoolean("CookieRequired");
                if (seen == null) {
                    setBackground(Color.LIGHT_GRAY);
                    setOpaque(true);
                } else if (params != null) {
                    if (params.length == 1 && params[0].startsWith("GET;COOKIE") && params[0].indexOf(';',5) == -1 && cookie==Boolean.FALSE) {
                        setOpaque(false);
                    } else {
                        setBackground(Color.PINK);
                        setOpaque(true);
                    }
                } else {
                    setOpaque(false);
                }
            } else {
                setOpaque(false);
            }
            return this;
        }
    }
    
    private class RequestEnumeration implements Enumeration {
        
        private String _method;
        private URL _url;
        private Object[][] _params;
        private String[][] _headers;
        private String[] _fuzzstrings;
        private int _param = 0;
        private int _fuzzindex = 0;
        // private boolean[] _haveRemoved;
        
        public RequestEnumeration(String method, URL url, Object[][] params, String[][] headers, String[] fuzzstrings) {
            _method = method;
            _url = url;
            _params = params;
            _headers = headers;
            _fuzzstrings = fuzzstrings;
            // _haveRemoved = new boolean[params.length];
            // for (int i=0; i<params.length; i++) 
            //     _haveRemoved[i] = false;
            
            _param = -1;
            _fuzzindex = fuzzstrings.length;
            increment();
        }
        
        /** Tests if this enumeration contains more elements.
         *
         * @return  <code>true</code> if and only if this enumeration object
         *           contains at least one more element to provide;
         *          <code>false</code> otherwise.
         *
         */
        public synchronized boolean hasMoreElements() {
            return _param < _params.length;
        }
        
        private void increment() {
            // if (_params[_param][5] == Boolean.TRUE && !_haveRemoved[_param]) {
            //     _haveRemoved[_param] = true;
            //     return;
            // }
            _fuzzindex++;
            if (_fuzzindex >= _fuzzstrings.length) {
                _fuzzindex = 0;
                _param++;
            }
            while (_param<_params.length && (_params[_param][4] == null || _params[_param][4] == Boolean.FALSE)) {
                _param++;
            }
        }
        
        /** Returns the next element of this enumeration if this enumeration
         * object has at least one more element to provide.
         *
         * @return     the next element of this enumeration.
         * @exception  NoSuchElementException  if no more elements exist.
         *
         */
        public synchronized Object nextElement() {
            if (hasMoreElements()) {
                Request request = new Request();
                request.setMethod(_method);
                request.setURL(_url);
                if (_param >= _params.length)
                    return null;
                request.setVersion(_version);
                request.setHeaders(_headers);
                if (request.getHeader("Host") == null) {
                    request.setHeader("Host", request.getURL().getHost());
                }
                String[][] parameters = new String[_params.length][3];
                for (int i=0; i<_params.length; i++) {
                    parameters[i][0] = (String)_params[i][0];
                    parameters[i][1] = (String)_params[i][1];
                    if (i == _param) {
                        parameters[i][2] = fuzzstrings[_fuzzindex];
                    } else {
                        parameters[i][2] = (String)_params[i][3];
                        if (parameters[i][2] == null) 
                            parameters[i][2] = "";
                    }
                }
                request.setParameters(parameters);
                increment();
                return request;
            }
            return null;
        }
    }
    
    private class Fetcher implements Runnable {

        private RequestEnumeration _re;
        private boolean _stopped = false;
        
        public Fetcher(RequestEnumeration re) {
            _re = re;
        }
        
        /** When an object implementing interface <code>Runnable</code> is used
         * to create a thread, starting the thread causes the object's
         * <code>run</code> method to be called in that separately executing
         * thread.
         * <p>
         * The general contract of the method <code>run</code> is that it may
         * take any action whatsoever.
         *
         * @see     java.lang.Thread#run()
         *
         */
        public void run() {
            URLFetcher uf = new URLFetcher();
            while (_re.hasMoreElements() && ! _stopped && ! _haltFetchers) {
                Request request = (Request) _re.nextElement();
                if (request == null) {
                    return;
                }
                Response response = uf.fetchResponse(request);
                if (response != null) {
                    boolean valid = false;
                    for (int i=0; i<_fetcher.length; i++) {
                        if (this == _fetcher[i]) {
                            valid = true;
                            continue;
                        }
                    }
                    if (!valid) {
                        return;
                    }
                    response.readContentStream();
                    String conversationID = model.newConversationID();
                    model.setServerRequest(conversationID, request);
                    model.setServerResponse(conversationID,  response);
                    model.setOrigin(conversationID, "Fuzzer");
                    if (response.getStatus().equals("500")) {
                        _haltFetchers = true;
                    }
                    updateStatus(request.getMethod() + " " + request.getURL() + " : " + response.getStatusLine());
                } else {
                    log("Got a null response in reply to " + request.getURL());
                }
            }
        }
        
        public void stop() {
            _stopped = true;
        }
    }
    
}
