/*
 * ConversationTableModel.java
 *
 * Created on April 28, 2003, 3:07 PM
 */

package za.org.dragon.exodus.plugins.Fuzzer;

import javax.swing.table.AbstractTableModel;

/**
 *
 * @author  rdawes
 */
public class ParameterTableModel extends AbstractTableModel {
    
    protected Object[][] data = new Object[0][0];
    protected String [] columnNames = {
        "Parameter Type", "Name", "Observed Values", "Fuzz value", "Fuzz this?", "Remove Parameter?"
    };
    
    // Types of the columns.
    static protected Class[]  cTypes = { String.class,
    String.class, String.class,
    String.class, Boolean.class, Boolean.class};
    
    public ParameterTableModel() {
    }
    
    public synchronized void clear() {
        data = new Object[0][0];
        fireTableDataChanged();
    }
    
    public synchronized void init(Object[][] params) {
        data = new Object[params.length][getColumnCount()];
        for (int i=0; i<params.length; i++) {
            for (int j=0; j<params[i].length; j++) {
                data[i][j] = params[i][j];
            }
        }
        fireTableStructureChanged();
    }
    
    public String getColumnName(int column) {
        if (column < columnNames.length) {
            return columnNames[column];
        }
        return "";
    }
    
    //XXX Should this really be synchronized?
    public synchronized int getColumnCount() {
        return columnNames.length;
    }
    
    public synchronized int getRowCount() {
        return data.length;
    }
    
    public synchronized Object getValueAt(int row, int column) {
        return data[row][column];
    }
    
    public Class getColumnClass(int column) {
        return cTypes[column];
    }
    
    public boolean isCellEditable(int row, int col) {
        if (col > 1) {
            return true;
        } else {
            return false;
        }
    }
    
    public void setValueAt(Object value, int row, int col) {
        data[row][col] = value;
        fireTableCellUpdated(row, col);
        if (col == 2) {
            data[row][3] = value;
            fireTableCellUpdated(row, 3);
        }
    }
    
    public Object[][] getData() {
        return data;
    }
    
}
