/*
 * ConversationEditorFrame.java
 *
 * Created on June 5, 2003, 8:43 PM
 */

package za.org.dragon.exodus.plugins.InteractiveIntercept;

import za.org.dragon.exodus.Request;
import za.org.dragon.exodus.RequestPanel;
import za.org.dragon.exodus.Response;
import za.org.dragon.exodus.ResponsePanel;

/**
 *
 * @author  rdawes
 */
public class ConversationEditorFrame extends javax.swing.JFrame {
    private Request _request = null;
    private RequestPanel _requestPanel;
    private Response _response = null;
    private ResponsePanel _responsePanel;
    
    /** Creates new form ConversationEditorFrame */
    public ConversationEditorFrame() {
        initComponents();
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        _requestPanel = new RequestPanel(null);
        getContentPane().add(_requestPanel, gridBagConstraints);
        _responsePanel = new ResponsePanel(null);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1;
        _responsePanel.setVisible(false);
        getContentPane().add(_responsePanel, gridBagConstraints);
    }

    public Request editRequest(Request request) {
        _request = request;
        _requestPanel.setEditable(true);
        _requestPanel.setRequest(request);
        synchronized (this) {
            try {
                this.wait();
            } catch (InterruptedException ie) {
                System.out.println("Wait interrupted");
            }
        }
        _requestPanel.setEditable(false);
        return _request;
    }
    
    public void setRequest(Request request) {
        _requestPanel.setRequest(request);
    }
    
    public Response editResponse(Response response) {
        _response = response;
        _responsePanel.setEditable(true);
        _responsePanel.setResponse(response);
        _responsePanel.setVisible(true);
        synchronized (this) {
            try {
                this.wait();
            } catch (InterruptedException ie) {
                System.out.println("Wait interrupted");
            }
        }
        _responsePanel.setEditable(false);
        return _response;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        cancelButton = new javax.swing.JButton();
        acceptButton = new javax.swing.JButton();
        abortButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Intercept");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(new java.awt.GridBagLayout());

        cancelButton.setText("Cancel edits");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jPanel1.add(cancelButton, new java.awt.GridBagConstraints());

        acceptButton.setText("Accept edits");
        acceptButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                acceptButtonActionPerformed(evt);
            }
        });

        jPanel1.add(acceptButton, new java.awt.GridBagConstraints());

        abortButton.setText("Abort request");
        abortButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                abortButtonActionPerformed(evt);
            }
        });

        jPanel1.add(abortButton, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(400, 500));
        setLocation((screenSize.width-400)/2,(screenSize.height-500)/2);
    }//GEN-END:initComponents

    private void abortButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_abortButtonActionPerformed
        _request = null;
        _response = null;
        synchronized (this) {
            this.notify();
        }
    }//GEN-LAST:event_abortButtonActionPerformed

    private void acceptButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_acceptButtonActionPerformed
        if (_response != null) {
            _response = _responsePanel.getResponse();
        } else if (_request != null) {
            _request = _requestPanel.getRequest();
        }
        synchronized (this) {
            this.notify();
        }
    }//GEN-LAST:event_acceptButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        synchronized (this) {
            this.notify();
        }
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        synchronized (this) {
            this.notify();
        }
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        try {
            ConversationEditorFrame cef = new ConversationEditorFrame();
            cef.show();
            Request request = new Request();
            request.setMethod("GET");
            request.setURL("http://localhost:8080/");
            request.setVersion("HTTP/1.0");
            request.setHeader("Accept","iamge/gif");
            Request r2 = cef.editRequest(request);
            System.out.println("Got " + r2.toString());
            Response response = new Response();
            response.setVersion("HTTP/1.0");
            response.setStatus("302");
            response.setMessage("Moved");
            response.setHeader("Location","http://localhost:8080/index.html");
            Response r3 = cef.editResponse(response);
            System.out.println("Got response " + r3.toString());
            cef.dispose();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton acceptButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton abortButton;
    // End of variables declaration//GEN-END:variables
    
}
