/*
 * ConversationPlugin.java
 *
 * Created on March 29, 2003, 10:31 AM
 */

package za.org.dragon.exodus.plugins.InteractiveIntercept;

import za.org.dragon.exodus.Exodus;
import za.org.dragon.exodus.Model;
import za.org.dragon.exodus.Request;
import za.org.dragon.exodus.Response;
import za.org.dragon.exodus.URLFilter;

import java.util.Properties;
import java.util.Enumeration;

/**
 *
 * @author  rdawes
 */
public class InteractiveRequestPlugin extends za.org.dragon.exodus.NullPlugin {
    
    private Exodus _exodus;
    private ProxyUI _ui = null;
    private Properties _props = new Properties(); // contains our default properties
    
    /** Creates a new instance of SiteInfoPlugin */
    public InteractiveRequestPlugin() {
    }
    
    public void init(Exodus exodus) {
        _exodus = exodus;
        _props.setProperty("InteractiveIntercept.methods", "POST");
        _props.setProperty("InteractiveIntercept.includeRegex", ".*");
        _props.setProperty("InteractiveIntercept.excludeRegex", ".*\\.(gif)|(jpg)|(css)|(js)$");
        configure(_props);
    }
    
    public String getPluginName() {
        return new String("Interactive Request");
    }
    
    public javax.swing.JPanel createMainInterface() {
        if (_ui == null) {
            _ui = new ProxyUI();
            configure(_props);
        }
        return _ui;
    }
    
    public void setProperties(Properties properties) {
        // This just allows us to copy our defaults over into
        // the main properties class, if they are not set already
        Enumeration propnames = _props.keys();
        while (propnames.hasMoreElements()) {
            String key = (String) propnames.nextElement();
            String value = properties.getProperty(key);
            if (value == null) {
                properties.setProperty(key,_props.getProperty(key));
            }
        }
        _props = properties;
        configure(properties);
    }
    
    private void configure(Properties properties) {
        if (_ui != null) {
            _ui.configure(properties);
        }
        
    }
    
    public URLFilter getFilter(URLFilter uf) {
        return new InteractiveRequestPlugin.ConversationEditor(uf);
    }
    
    private class ConversationEditor implements URLFilter {
        
        private URLFilter _uf;
        private Request _request = null;
        private Response _response = null;
        private boolean _requestChanged = false;
        private boolean _responseChanged = false;
        
        public ConversationEditor(URLFilter uf) {
            _uf = uf;
        }
        
        public Response fetchResponse(Request request) {
            ConversationEditorFrame cef = null;
            _request = request;
            if (_ui != null && _ui.interceptRequest(request)) {
                _request.readContentStream();
                cef = new ConversationEditorFrame();
                cef.show();
                _request = cef.editRequest(_request);
                if (_request == null) {
                    _response = new Response();
                    _response.setVersion("HTTP/1.0");
                    _response.setStatus("500");
                    _response.setMessage("Request aborted");
                    _response.setHeader("Content-Type","text/html");
                    _response.setContent("<HTML><HEAD><TITLE>Request aborted</TITLE></HEAD><BODY>Request aborted in InteractiveRequestPlugin</BODY></HTML>".getBytes());
                    return _response;
                }
				cef.hide();
            }
            _response = _uf.fetchResponse(_request);
            if (_ui != null && _ui.revealHiddenFields(_response)) {
                _response.readContentStream();
                _response.setContent(revealHidden(_response.getContent()));
            }
            if (_ui != null && _ui.interceptResponse(_response)) {
                if (cef == null) {
                    cef = new ConversationEditorFrame();
                    cef.setRequest(request);
                }
                cef.show();
                _response.readContentStream();
                _response = cef.editResponse(_response);
                if (_response == null) {
                    _response = new Response();
                    _response.setVersion("HTTP/1.0");
                    _response.setStatus("500");
                    _response.setMessage("Request aborted");
                    _response.setHeader("Content-Type","text/html");
                    _response.setContent("<HTML><HEAD><TITLE>Request aborted</TITLE></HEAD><BODY>Request aborted in InteractiveRequestPlugin</BODY></HTML>".getBytes());
                    return _response;
                }
				cef.hide();
            }
            if (cef != null) {
                cef.dispose();
            }
            return _response;
        }
        
        public Request getRequest() {
            return _request;
        }
        
        public Response getResponse() {
            return _response;
        }
        
        public boolean requestChanged() {
            return _requestChanged;
        }
        
        public boolean responseChanged() {
            return _responseChanged;
        }
        
        private byte[] revealHidden(byte[] content) {
            String text = new String(content);
            text = text.replaceAll("type=\"[Hh][Ii][Dd][Dd][Ee][Nn]\"", "  type=\"text\"");
            text = text.replaceAll("type='[Hh][Ii][Dd][Dd][Ee][Nn]'", "  type='text'");
            text = text.replaceAll("type=[Hh][Ii][Dd][Dd][Ee][Nn]", "  type=text");
            return text.getBytes();
        }
        
    }
}
