/*
 * $Id: ProxyUI.java,v 1.8 2003/06/05 20:47:08 rdawes Exp $
 * ProxyUI.java
 *
 * Created on February 17, 2003, 9:05 PM
 */

package za.org.dragon.exodus.plugins.InteractiveIntercept;

import za.org.dragon.exodus.Request;
import za.org.dragon.exodus.Response;

import javax.swing.JFrame;
import java.io.IOException;

import java.util.Properties;

import javax.swing.ListModel;

import java.util.logging.Logger;

/**
 *
 * @author  rdawes
 */
public class ProxyUI extends javax.swing.JPanel {
    
    private Properties props = null;
    private Logger logger = Logger.getLogger("za.org.dragon.exodus");
    
    /** Creates new form ProxyUI */
    public ProxyUI() {
        initComponents();
    }
    
    public void configure(Properties props) {
        this.props = props;
        String methods = props.getProperty("InteractiveIntercept.methods");
        if ( methods != null && !methods.equals("")) {
            String[] items = methods.split(" *, *");
            int[] indices = new int[items.length];
            ListModel listModel = interceptMethodList.getModel();
            for (int i=0; i< listModel.getSize(); i++) {
                String item = (String) listModel.getElementAt(i);
                for (int j=0; j < items.length; j++) {
                    if (items[j].equals(item)) {
                        indices[j] = i;
                    }
                }
            }
            interceptMethodList.setSelectedIndices(indices);
        }
        // Still need to implement a ListSelectionListener, so that we can update
        // the props whenever the method list selection changes FIXME
        String includeRegex = props.getProperty("InteractiveIntercept.includeRegex");
        if (includeRegex != null) {
            interceptIncludeRegexTextField.setText(includeRegex);
        }
        String excludeRegex = props.getProperty("InteractiveIntercept.excludeRegex");
        if (excludeRegex != null) {
            interceptExcludeRegexTextField.setText(excludeRegex);
        }
    }
    
    public boolean interceptRequest(Request request) {
        if (request != null && interceptRequestCheckBox.isSelected()) {
            String includeRegex = props.getProperty("InteractiveIntercept.includeRegex");
            String excludeRegex = props.getProperty("InteractiveIntercept.excludeRegex");
            String url = request.getURL().toString();
            String method = request.getMethod();
            Object[] methods = interceptMethodList.getSelectedValues();
            if (methods != null) {
                boolean methodOK = false;
                for (int i=0; i < methods.length; i++) {
                    if (((String)methods[i]).equalsIgnoreCase(method)) {
                        methodOK = true;
                    }
                }
                if (! methodOK) {
                    return false;
                }
            } else {
                // No methods selected!
                return false;
            }
            if (!excludeRegex.equals("") && url.matches(excludeRegex)) {
                // an exclude regex matched, so we stop immediately
                return false;
            }
            if (!includeRegex.equals("")) {
                // an include regex was set
                if (url.matches(includeRegex)) {
                    // and matched so we queue the conversation
                    return true;
                } else {
                    // but didn't match, so we stop immediately
                    return false;
                }
            } else {
                // no regexes were set, so we intercept the request
                return true;
            }
        }
        return false;
    }
    
    public boolean revealHiddenFields(Response response) {
        if (response != null && interceptHiddenFieldCheckBox.isSelected()) {
            String ct = response.getHeader("Content-Type");
            if (ct == null) {
                return false;
            } else if (ct.matches("text/.*")) {
                return true;
            }
        }
        return false;
    }
    
    public boolean interceptResponse(Response response) {
        if (response != null && interceptResponseCheckBox.isSelected()) {
            String contentType = response.getHeader("Content-Type");
            if (contentType != null && contentType.matches("text/.*")) {
                // we can test against the fancy MIME-Types later once it is implemented
                // but that is not really important yet
                return true;
            }
        }
        return false;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        interceptrequestPanel = new javax.swing.JPanel();
        interceptRequestCheckBox = new javax.swing.JCheckBox();
        interceptIncludeLabel = new javax.swing.JLabel();
        interceptIncludeRegexTextField = new javax.swing.JTextField();
        interceptExcludeLabel = new javax.swing.JLabel();
        interceptExcludeRegexTextField = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        interceptMethodList = new javax.swing.JList();
        interceptNextRequestCheckBox = new javax.swing.JCheckBox();
        interceptResponsePanel = new javax.swing.JPanel();
        interceptResponseCheckBox = new javax.swing.JCheckBox();
        interceptExcludeButton = new javax.swing.JButton();
        interceptIncludeButton = new javax.swing.JButton();
        interceptAddNewTextField = new javax.swing.JTextField();
        interceptAddNewButton = new javax.swing.JButton();
        interceptHiddenFieldCheckBox = new javax.swing.JCheckBox();
        jScrollPane4 = new javax.swing.JScrollPane();
        interceptIncludeMIMEList = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane5 = new javax.swing.JScrollPane();
        interceptExcludeMIMEList = new javax.swing.JList();
        jLabel2 = new javax.swing.JLabel();
        interceptNextResponseCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        interceptrequestPanel.setLayout(new java.awt.GridBagLayout());

        interceptRequestCheckBox.setText("Intercept requests : ");
        interceptRequestCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        interceptRequestCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interceptRequestCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        interceptrequestPanel.add(interceptRequestCheckBox, gridBagConstraints);

        interceptIncludeLabel.setText("Include Paths matching : ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        interceptrequestPanel.add(interceptIncludeLabel, gridBagConstraints);

        interceptIncludeRegexTextField.setToolTipText("Use a regular expression to select which URLs to intercept. Leave blank to ignore.");
        interceptIncludeRegexTextField.setEnabled(false);
        interceptIncludeRegexTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interceptIncludeRegexTextFieldActionPerformed(evt);
            }
        });

        interceptIncludeRegexTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                interceptIncludeRegexTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        interceptrequestPanel.add(interceptIncludeRegexTextField, gridBagConstraints);

        interceptExcludeLabel.setText("Exclude paths matching : ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        interceptrequestPanel.add(interceptExcludeLabel, gridBagConstraints);

        interceptExcludeRegexTextField.setToolTipText("Use a regular expression to select which URLs not to intercept. Leave blank to ignore.");
        interceptExcludeRegexTextField.setEnabled(false);
        interceptExcludeRegexTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interceptExcludeRegexTextFieldActionPerformed(evt);
            }
        });

        interceptExcludeRegexTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                interceptExcludeRegexTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        interceptrequestPanel.add(interceptExcludeRegexTextField, gridBagConstraints);

        jScrollPane3.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane3.setViewportBorder(new javax.swing.border.TitledBorder("Methods"));
        jScrollPane3.setMinimumSize(new java.awt.Dimension(100, 120));
        jScrollPane3.setPreferredSize(new java.awt.Dimension(100, 120));
        jScrollPane3.setAutoscrolls(true);
        interceptMethodList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "GET", "POST", "HEAD", "PUT", "DELETE", "TRACE", "CONNECT", "PROPFIND", "OPTIONS" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        interceptMethodList.setToolTipText("Select which request methods to intercept");
        interceptMethodList.setVisibleRowCount(0);
        interceptMethodList.setEnabled(false);
        jScrollPane3.setViewportView(interceptMethodList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        interceptrequestPanel.add(jScrollPane3, gridBagConstraints);

        interceptNextRequestCheckBox.setText("Intercept next request only : ");
        interceptNextRequestCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        interceptNextRequestCheckBox.setEnabled(false);
        interceptNextRequestCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interceptNextRequestCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        interceptrequestPanel.add(interceptNextRequestCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(interceptrequestPanel, gridBagConstraints);

        interceptResponsePanel.setLayout(new java.awt.GridBagLayout());

        interceptResponseCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        interceptResponseCheckBox.setLabel("Intercept responses : ");
        interceptResponseCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interceptResponseCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        interceptResponsePanel.add(interceptResponseCheckBox, gridBagConstraints);

        interceptExcludeButton.setText("Exclude >>");
        interceptExcludeButton.setPreferredSize(null);
        interceptExcludeButton.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weighty = 1.0;
        interceptResponsePanel.add(interceptExcludeButton, gridBagConstraints);

        interceptIncludeButton.setText("<< Include");
        interceptIncludeButton.setMinimumSize(new java.awt.Dimension(96, 26));
        interceptIncludeButton.setPreferredSize(null);
        interceptIncludeButton.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        interceptResponsePanel.add(interceptIncludeButton, gridBagConstraints);

        interceptAddNewTextField.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        interceptResponsePanel.add(interceptAddNewTextField, gridBagConstraints);

        interceptAddNewButton.setText("<< Add new");
        interceptAddNewButton.setMinimumSize(new java.awt.Dimension(96, 26));
        interceptAddNewButton.setPreferredSize(null);
        interceptAddNewButton.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        interceptResponsePanel.add(interceptAddNewButton, gridBagConstraints);

        interceptHiddenFieldCheckBox.setText("Reveal hidden fields in HTML pages : ");
        interceptHiddenFieldCheckBox.setToolTipText("Select this to change all hidden form fields to text fields. Looks at pages of type HTML and javascript.");
        interceptHiddenFieldCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        interceptResponsePanel.add(interceptHiddenFieldCheckBox, gridBagConstraints);

        jScrollPane4.setMinimumSize(new java.awt.Dimension(32, 100));
        jScrollPane4.setPreferredSize(new java.awt.Dimension(45, 120));
        interceptIncludeMIMEList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "text/*" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        interceptIncludeMIMEList.setToolTipText("Select which MIME-Types to intercept. Use the Exclude and Include buttons to choose.");
        interceptIncludeMIMEList.setEnabled(false);
        jScrollPane4.setViewportView(interceptIncludeMIMEList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        interceptResponsePanel.add(jScrollPane4, gridBagConstraints);

        jLabel1.setText("Include MIME-Types");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        interceptResponsePanel.add(jLabel1, gridBagConstraints);

        jScrollPane5.setMinimumSize(new java.awt.Dimension(32, 100));
        jScrollPane5.setPreferredSize(new java.awt.Dimension(85, 120));
        interceptExcludeMIMEList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "image/*", "application/*", "x-audio/*" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        interceptExcludeMIMEList.setToolTipText("Select which MIME-Types not to intercept. Use the Exclude and Include buttons to choose.");
        interceptExcludeMIMEList.setEnabled(false);
        jScrollPane5.setViewportView(interceptExcludeMIMEList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        interceptResponsePanel.add(jScrollPane5, gridBagConstraints);

        jLabel2.setText("Exclude MIME-Types");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        interceptResponsePanel.add(jLabel2, gridBagConstraints);

        interceptNextResponseCheckBox.setText("Intercept next response only : ");
        interceptNextResponseCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        interceptNextResponseCheckBox.setEnabled(false);
        interceptNextResponseCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interceptNextResponseCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        interceptResponsePanel.add(interceptNextResponseCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(interceptResponsePanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void interceptExcludeRegexTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_interceptExcludeRegexTextFieldFocusLost
        updateExcludeRegex();
    }//GEN-LAST:event_interceptExcludeRegexTextFieldFocusLost

    private void interceptExcludeRegexTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interceptExcludeRegexTextFieldActionPerformed
        updateExcludeRegex();
    }//GEN-LAST:event_interceptExcludeRegexTextFieldActionPerformed

    private void updateExcludeRegex() {
        props.setProperty("InteractiveIntercept.excludeRegex",interceptExcludeRegexTextField.getText());
    }
    
    private void interceptIncludeRegexTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_interceptIncludeRegexTextFieldFocusLost
        updateIncludeRegex();
    }//GEN-LAST:event_interceptIncludeRegexTextFieldFocusLost

    private void interceptIncludeRegexTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interceptIncludeRegexTextFieldActionPerformed
        updateIncludeRegex();
    }//GEN-LAST:event_interceptIncludeRegexTextFieldActionPerformed

    private void updateIncludeRegex() {
        props.setProperty("InteractiveIntercept.includeRegex",interceptIncludeRegexTextField.getText());
    }
    
    private void interceptResponseCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interceptResponseCheckBoxActionPerformed
        if (interceptResponseCheckBox.isSelected()) {
            interceptNextResponseCheckBox.setSelected(false);
        }
    }//GEN-LAST:event_interceptResponseCheckBoxActionPerformed
    
    private void interceptNextResponseCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interceptNextResponseCheckBoxActionPerformed
        if(interceptNextResponseCheckBox.isSelected()) {
            interceptResponseCheckBox.setSelected(false);
        }
    }//GEN-LAST:event_interceptNextResponseCheckBoxActionPerformed
    
    private void interceptNextRequestCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interceptNextRequestCheckBoxActionPerformed
        boolean enabled = false;
        boolean isSelected = interceptNextRequestCheckBox.isSelected();
        if (isSelected) {
            interceptRequestCheckBox.setSelected(false);
            enabled = true;
        } else {
            if (interceptRequestCheckBox.isSelected()) {
                enabled = true;
            }
        }
        interceptIncludeRegexTextField.setEnabled(enabled);
        interceptExcludeRegexTextField.setEnabled(enabled);
        interceptMethodList.setEnabled(enabled);
    }//GEN-LAST:event_interceptNextRequestCheckBoxActionPerformed
    
    private void interceptRequestCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interceptRequestCheckBoxActionPerformed
        boolean enabled = false;
        boolean isSelected = interceptRequestCheckBox.isSelected();
        if (isSelected) {
            interceptNextRequestCheckBox.setSelected(false);
            enabled = true;
        } else {
            if (interceptNextRequestCheckBox.isSelected()) {
                enabled = true;
            }
        }
        interceptIncludeRegexTextField.setEnabled(enabled);
        interceptExcludeRegexTextField.setEnabled(enabled);
        interceptMethodList.setEnabled(enabled);
    }//GEN-LAST:event_interceptRequestCheckBoxActionPerformed
                
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel interceptrequestPanel;
    private javax.swing.JButton interceptIncludeButton;
    private javax.swing.JCheckBox interceptNextRequestCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton interceptExcludeButton;
    private javax.swing.JCheckBox interceptRequestCheckBox;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JLabel interceptIncludeLabel;
    private javax.swing.JList interceptExcludeMIMEList;
    private javax.swing.JLabel interceptExcludeLabel;
    private javax.swing.JCheckBox interceptResponseCheckBox;
    private javax.swing.JCheckBox interceptHiddenFieldCheckBox;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JCheckBox interceptNextResponseCheckBox;
    private javax.swing.JList interceptIncludeMIMEList;
    private javax.swing.JButton interceptAddNewButton;
    private javax.swing.JTextField interceptExcludeRegexTextField;
    private javax.swing.JTextField interceptAddNewTextField;
    private javax.swing.JList interceptMethodList;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JPanel interceptResponsePanel;
    private javax.swing.JTextField interceptIncludeRegexTextField;
    // End of variables declaration//GEN-END:variables
    
}
