/*
 * ManualRequestUI.java
 *
 * Created on March 31, 2003, 10:46 PM
 */

package za.org.dragon.exodus.plugins.ManualRequest;

import za.org.dragon.exodus.Model;

import za.org.dragon.exodus.Request;
import za.org.dragon.exodus.RequestPanel;
import za.org.dragon.exodus.Response;
import za.org.dragon.exodus.ResponsePanel;
import za.org.dragon.exodus.URLFetcher;
import za.org.dragon.exodus.SwingWorker;

import javax.swing.DefaultComboBoxModel;
import javax.swing.table.TableModel;
import javax.swing.event.TableModelListener;
import javax.swing.event.TableModelEvent;

import java.util.logging.Logger;

/**
 *
 * @author  rdawes
 */
public class ManualRequestUI extends javax.swing.JPanel {
    
    private Model _model = null;
    private RequestPanel requestPanel;
    private ResponsePanel responsePanel;
    private SwingWorker _sw = null;
    private Logger logger = Logger.getLogger("za.org.dragon.exodus");
    
    /** Creates new form ManualRequestUI */
    public ManualRequestUI(Model model) {
        _model = model;
        initComponents();
        requestPanel = new RequestPanel(null,true);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        requestPane.add(requestPanel, gridBagConstraints);
        
        responsePanel = new ResponsePanel();
        displaySplitPane.setRightComponent(responsePanel);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        conversationComboBox = new javax.swing.JComboBox();
        displaySplitPane = new javax.swing.JSplitPane();
        requestPane = new javax.swing.JPanel();
        submitButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Conversation");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabel1, gridBagConstraints);

        conversationComboBox.setModel(new TableListAdapter(_model.getConversationTableModel()));
        conversationComboBox.setMinimumSize(new java.awt.Dimension(100, 25));
        conversationComboBox.setPreferredSize(new java.awt.Dimension(100, 25));
        conversationComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                conversationComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(conversationComboBox, gridBagConstraints);

        displaySplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        displaySplitPane.setResizeWeight(0.2);
        requestPane.setLayout(new java.awt.GridBagLayout());

        submitButton.setText("Submit");
        submitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                submitButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        requestPane.add(submitButton, gridBagConstraints);

        displaySplitPane.setLeftComponent(requestPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(displaySplitPane, gridBagConstraints);

    }//GEN-END:initComponents

    private void submitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitButtonActionPerformed
        responsePanel.setResponse(null);
        System.out.println("In submitButtonActionPerformed()");
        if (_sw == null) {
            final Request request = requestPanel.getRequest();
            System.out.println("request is " + request);
            if (request!=null) {
                System.out.println("creating the SW");
                _sw = new SwingWorker() {
                    Response response = null;
                    
                    public Object construct() {
                        URLFetcher uf = new URLFetcher();
                        response = uf.fetchResponse(request);
                        response.readContentStream();
                        return response;
                    }
                                                                                
                    //Runs on the event-dispatching thread.
                    public void finished() {
                        if (this == _sw) { // we were not cancelled
                            responsePanel.setResponse(response);
                            String id = _model.newConversationID();
                            _model.setServerRequest(id, request);
                            _model.setServerResponse(id, response);
                            _model.setOrigin(id, "Manual Request");
                            submitButton.setText("Submit");
                            _sw = null;
                        }
                    }
                };
                _sw.start();  //required for SwingWorker 3
                logger.info("Worker thread started for " + request.getURL());
                submitButton.setText("Cancel");
            } else {
                System.out.println("Request was null");
            }
        } else {
            System.out.println("_sw is " + _sw);
            _sw = null;
            submitButton.setText("Submit");
        }
    }//GEN-LAST:event_submitButtonActionPerformed

    private void conversationComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_conversationComboBoxActionPerformed
        requestPanel.setRequest(null);
        responsePanel.setResponse(null);
        Object id = conversationComboBox.getSelectedItem();
        Request request = _model.getServerRequest((String) id);
        if (request != null) {
            requestPanel.setRequest(request);
        }
    }//GEN-LAST:event_conversationComboBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JSplitPane displaySplitPane;
    private javax.swing.JButton submitButton;
    private javax.swing.JPanel requestPane;
    private javax.swing.JComboBox conversationComboBox;
    // End of variables declaration//GEN-END:variables
    
    private class TableListAdapter extends DefaultComboBoxModel {
        
        TableModel _table;
        int _selected = -1;
        
        protected TableListAdapter(TableModel table) {
            _table = table;
            _table.addTableModelListener(new TableModelListener() {
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == e.INSERT) {
                        fireIntervalAdded(this, e.getFirstRow(), e.getLastRow());
                    } else if (e.getType() == e.DELETE) {
                        fireIntervalRemoved(this, e.getFirstRow(), e.getLastRow());
                    } else if (e.getType() == e.UPDATE) {
                        fireContentsChanged(this, e.getFirstRow(), e.getLastRow());
                    }
                }
            });
        }
        
        public void addElement(Object anObject) {}

        public Object getElementAt(int index) {
            return _table.getValueAt(index,0);
        }
        
        public int getIndexOf(Object anObject) {
            return -1; // not implemented
        }

        public Object getSelectedItem() {
            if (_selected < 0) {
                return "";
            }
            return _table.getValueAt(_selected,0);
        }
        
        public int getSize() {
            return _table.getRowCount();
        }

        public void insertElementAt(Object anObject, int index) {}

        public void removeAllElements() {}

        public void removeElement(Object anObject) {}

        public void removeElementAt(int index) {}

        public void setSelectedItem(Object anObject) {
            _selected = -1;
            for (int i=0; i< _table.getRowCount(); i++) {
                if (_table.getValueAt(i,0).equals(anObject)) {
                    _selected = i;
                    continue;
                }
            }
            System.out.println("Set _selected to " + _selected);
        }

    }
    
}
