/*
 * SessionID.java
 *
 * Created on May 4, 2003, 10:03 PM
 */

package za.org.dragon.exodus.plugins.SessionidAnalysis;

import java.math.BigInteger;
import java.util.Date;

/**
 *
 * @author  rdawes
 */
public class SessionID {
    
    private static Object lock = new Object();
    
    public static final int MAXLENGTH = 100;
    
    // FIXME - broken! We need to sort the character set before calculating!
    private static char[][] charset = new char[MAXLENGTH][128];
    private static int[] last = new int[MAXLENGTH];
    private static boolean _unsorted = false;
    
    private String value;
    
    private Date date;
    
    private BigInteger intvalue = null;
    
    /** Creates a new instance of SessionID */
    public SessionID(String value, Date date) {
        this.value = value;
        this.date = date;
        synchronized (lock) {
            for (int i=0; i<value.length(); i++) {
                char ch = value.charAt(i);
                for (int j=0; j<charset[i].length; j++) {
                    if (charset[i][j] == 0) {
                        charset[i][j] = ch;
                        last[i] = j;
                        _unsorted = true;
                        break;
                    } else if (ch == charset[i][j]) {
                        break;
                    }
                }
            }
        }
    }
    
    private void sort() {
        if (!_unsorted) return;
        // trivial bubble sort
        synchronized (lock) {
            for (int i = 0; i<MAXLENGTH; i++) {
                if (last[i] == 0) break;
                for (int j=0; j<last[i]; j++) {
                    for (int k=j+1; k<=last[i]; k++) {
                        if (charset[i][j] > charset[i][k]) {
                            char ch = charset[i][j];
                            charset[i][j] = charset[i][k];
                            charset[i][k] = ch;
                        }
                    }
                }
                String s = new String(charset[i]);
                System.out.println("S is '" + s + "'");
            }
        }
        _unsorted = false;
    }
    
    public String getValue() {
        return this.value;
    }
    
    public Date getDate() {
        return this.date;
    }
    
    public void calcIntValue() {
        sort();
        synchronized (lock) {
            BigInteger total = BigInteger.ZERO;
            for (int i=value.length()-1; i>=0; i--) {
                String s = new String(charset[i]);
                char ch = value.charAt(i);
                BigInteger val = new BigInteger(Integer.toString(s.indexOf(ch)));
                BigInteger base = new BigInteger(Integer.toString(last[i]));
                base = base.pow(value.length()-1-i);
                total = total.add(base.multiply(val));
            }
            intvalue = total;
        }
    }
    
    public BigInteger getIntValue() {
        return intvalue;
    }
    
    public static void main(String[] args) {
        SessionID i2 = new SessionID("aaaab", null);
        SessionID i1 = new SessionID("bbbba", null);
        SessionID i3 = new SessionID("aaaac", null);
        SessionID i4 = new SessionID("aaaad", null);
        SessionID i5 = new SessionID("baaae", null);
        SessionID i6 = new SessionID("caaae", null);
        i6.calcIntValue();
        System.out.println(i6.getIntValue());
    }
}
