/*
 * ConversationPlugin.java
 *
 * Created on March 29, 2003, 10:31 AM
 */

package za.org.dragon.exodus.plugins.SessionidAnalysis;

import za.org.dragon.exodus.*;

/**
 *
 * @author  rdawes
 */
public class SessionidPlugin extends za.org.dragon.exodus.NullPlugin {

    private Exodus _exodus;
    private SessionidUI ui = null;
    private SessionidConfig config = null;
    private MessageLog log = null;
    private int threads = 4;
    
    /** Creates a new instance of SpiderPlugin */
    public SessionidPlugin() {
    }
    
    public void init(Exodus exodus) {
        _exodus = exodus;
    }
    
    public String getPluginName() {
        return new String("Session ID Analysis");
    }
    
    public void setLog(MessageLog log) {
        this.log = log;
    }
    
    public javax.swing.JPanel createMainInterface() {
        ui = new SessionidUI(_exodus.getModel(), log);
        ui.setThreads(threads);
        return ui;
    }
    
    public javax.swing.JPanel createConfigInterface() {
        config = new SessionidConfig(this);
        return config;
    }
    
    public String acceptConfig(boolean commit) {
        if (config != null) {
            return config.acceptConfig(commit);
        }
        return "";
    }
    
    protected int getThreads() {
        return threads;
    }
    
    protected void setThreads(int threads) {
        this.threads = threads;
        ui.setThreads(threads);
    }
    
}
