/*
 * CookieUI.java
 *
 * Created on March 12, 2003, 11:32 PM
 */

package za.org.dragon.exodus.plugins.SessionidAnalysis;

import za.org.dragon.exodus.*;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;

import java.util.ArrayList;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;

import javax.swing.JFileChooser;
import java.io.FileOutputStream;
import java.io.File;

import java.lang.Thread;

/**
 *
 * @author  rdawes
 */
public class SessionidUI extends javax.swing.JPanel {
    
    private MessageLog messageLog = null;
    private Model model;
    private int threads = 1;
    private DefaultComboBoxModel domainComboModel;
    private DefaultComboBoxModel cookieComboModel;
    private ArrayList domains = new ArrayList(1);
    private ArrayList names = new ArrayList(1);
    private URLFetcher[] uf = null;
    private URLFetcher testuf = null;
    private Request idrequest;
    private Integer idsrequested;
    private ArrayList sessionids = new ArrayList(1);
    private SessionidTableModel sessionidTableModel = new SessionidTableModel();
    private RequestPanel requestPanel;
    
    private SessionidUI.RequestEnumeration _re = null;
    private boolean _haltFetchers = false;
    private SessionidUI.Fetcher[] _fetcher = null;
    
    /** Creates new form CookieUI */
    public SessionidUI(Model model, MessageLog messagelog) {
        this.messageLog = messagelog;
        this.model = model;

        initComponents();
        
        requestPanel = new RequestPanel(null,true);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(requestPanel, gridBagConstraints);
        
    }
    
    public void setThreads(int threads) {
        this.threads = threads;
    }
    
    private void log(String message) {
        if (messageLog == null) {
            System.out.println("SessionID : " + message);
        } else {
            messageLog.log("SessionID : " + message);
        }
    }

    private synchronized void updateStatus(final String value, final Date date) {
        SessionID id = new SessionID(value, date);
        synchronized (sessionids) {
            sessionids.add(id);
            sessionidTableModel.update(id);
        }
        
        SwingWorker sw = new SwingWorker() {
            public Object construct() { return null; }
            
            public void finished() {
                dateTextField.setText(date.toString());
                stringTextField.setText(value);
                quantitySpinner.setValue(new Integer(((Integer)quantitySpinner.getValue()).intValue()-1));
                if (!_re.hasMoreElements() || _haltFetchers) {
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                }
            }
        };
        sw.start();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        idTypeButtonGroup = new javax.swing.ButtonGroup();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        setCookieTable = new javax.swing.JTable();
        testButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        quantitySpinner = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane5 = new javax.swing.JScrollPane();
        responseLogTextPane = new javax.swing.JTextPane();
        idCookieRadioButton = new javax.swing.JRadioButton();
        idContentRadioButton = new javax.swing.JRadioButton();
        jLabel5 = new javax.swing.JLabel();
        regexTextField = new javax.swing.JTextField();
        dateTextField = new javax.swing.JTextField();
        stringTextField = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        startButton = new javax.swing.JButton();
        stopButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        seriesButton = new javax.swing.JButton();
        seriesComboBox = new javax.swing.JComboBox();
        jScrollPane3 = new javax.swing.JScrollPane();
        seriesList = new javax.swing.JList();
        rangeStartSpinner = new javax.swing.JSpinner();
        rangeStopSpinner = new javax.swing.JSpinner();
        calculateButton = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        exportButton = new javax.swing.JButton();
        jScrollPane4 = new javax.swing.JScrollPane();
        valuesTable = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setMinimumSize(new java.awt.Dimension(100, 100));
        setCookieTable.setModel(model.getConversationTableModel());
        jScrollPane1.setViewportView(setCookieTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        testButton.setText("Test Request");
        testButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                testButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        jPanel1.add(testButton, gridBagConstraints);

        jLabel1.setText("Sample size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel1, gridBagConstraints);

        quantitySpinner.setMinimumSize(new java.awt.Dimension(60, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(quantitySpinner, gridBagConstraints);

        jLabel2.setText("Customise request");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel2, gridBagConstraints);

        jLabel3.setLabelFor(jScrollPane1);
        jLabel3.setText("Conversations");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel3, gridBagConstraints);

        jLabel4.setLabelFor(jScrollPane5);
        jLabel4.setText("Results");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel4, gridBagConstraints);

        responseLogTextPane.setBackground(new java.awt.Color(204, 204, 204));
        jScrollPane5.setViewportView(responseLogTextPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jScrollPane5, gridBagConstraints);

        idCookieRadioButton.setSelected(true);
        idCookieRadioButton.setText("Cookie-based Session ID");
        idTypeButtonGroup.add(idCookieRadioButton);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel1.add(idCookieRadioButton, gridBagConstraints);

        idContentRadioButton.setText("Content-based SessionID");
        idTypeButtonGroup.add(idContentRadioButton);
        idContentRadioButton.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel1.add(idContentRadioButton, gridBagConstraints);

        jLabel5.setText("Session ID matches");
        jLabel5.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel5, gridBagConstraints);

        regexTextField.setText("Set-Cookie: \\w+=(\\w+)");
        regexTextField.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(regexTextField, gridBagConstraints);

        dateTextField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(dateTextField, gridBagConstraints);

        stringTextField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(stringTextField, gridBagConstraints);

        startButton.setText("Go!");
        startButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startButtonActionPerformed(evt);
            }
        });

        jPanel4.add(startButton);

        stopButton.setText("Stop");
        stopButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopButtonActionPerformed(evt);
            }
        });

        jPanel4.add(stopButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(jPanel4, gridBagConstraints);

        jTabbedPane1.addTab("Collect", jPanel1);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        seriesButton.setText("Identify Series");
        seriesButton.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(seriesButton, gridBagConstraints);

        seriesComboBox.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(seriesComboBox, gridBagConstraints);

        seriesList.setEnabled(false);
        jScrollPane3.setViewportView(seriesList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        jPanel2.add(jScrollPane3, gridBagConstraints);

        rangeStartSpinner.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(rangeStartSpinner, gridBagConstraints);

        rangeStopSpinner.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(rangeStopSpinner, gridBagConstraints);

        calculateButton.setText("Calculate");
        calculateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                calculateButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel2.add(calculateButton, gridBagConstraints);

        jLabel7.setText("Start range");
        jLabel7.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jLabel7, gridBagConstraints);

        jLabel8.setText("End range");
        jLabel8.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jLabel8, gridBagConstraints);

        exportButton.setText("Export");
        exportButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel2.add(exportButton, gridBagConstraints);

        valuesTable.setFont(new java.awt.Font("Courier New", 0, 12));
        valuesTable.setModel(sessionidTableModel);
        jScrollPane4.setViewportView(valuesTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane4, gridBagConstraints);

        jTabbedPane1.addTab("Analyse", jPanel2);

        jTabbedPane1.addTab("Graph", jPanel3);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jTabbedPane1, gridBagConstraints);

    }//GEN-END:initComponents

    private void stopButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopButtonActionPerformed
        _haltFetchers = true;
        for (int i=0; i<threads; i++) {
            if (_fetcher[i] != null) {
                _fetcher[i].stop();
                _fetcher[i] = null;
            }
        }
        startButton.setEnabled(true);
        stopButton.setEnabled(false);
    }//GEN-LAST:event_stopButtonActionPerformed
    
    private void calculateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_calculateButtonActionPerformed
        calculateButton.setEnabled(false);
        new Thread(new Runnable() {
            public void run() {
                SessionID s;
                for (int i=0; i< sessionids.size(); i++) {
                    s = (SessionID) sessionids.get(i);
                    s.calcIntValue();
                    sessionidTableModel.fireTableRowsUpdated(i,i);
                }
                calculateButton.setEnabled(true);
            }
        }).start();
    }//GEN-LAST:event_calculateButtonActionPerformed
    
    private void exportButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportButtonActionPerformed
        log("Should be exporting now!");
        JFileChooser fc = new JFileChooser();
        // fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(null);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            //This is where a real application would open the file.
            log("Saving cookies to : " + file.toString());
            try {
                FileOutputStream fos = new FileOutputStream(file);
                if (file.isFile() && file.canWrite()) {
                    for (int i=0; i<sessionids.size(); i++) {
                        SessionID s = (SessionID) sessionids.get(i);
                        fos.write(new String(s.getDate() + " " + s.getValue() + " " + s.getIntValue()).getBytes());
                    }
                }
            } catch (IOException ioe) {
                log("IOException writing cookies : " + ioe);
            }
        } else {
            log("Export command cancelled by user");
        }        
    }//GEN-LAST:event_exportButtonActionPerformed
    
    private void testButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_testButtonActionPerformed
        Request request = requestPanel.getRequest();
        if (request != null) 
            fetchRequest(request);
    }//GEN-LAST:event_testButtonActionPerformed
    
    // fetch the request in a separate thread.
    private void fetchRequest(final Request request) {
        testButton.setEnabled(false);
        SwingWorker sw = new SwingWorker() {
            private Response response = null;
            public Object construct() {
                URLFetcher uf = new URLFetcher();
                response = uf.fetchResponse(request);
                response.readContentStream();
                return response;
            }
            public void finished() {
                responseLogTextPane.setText(response.toString());
                testButton.setEnabled(true);
            }
        };
        sw.start();
    }
    
    private void startButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startButtonActionPerformed
        Request request = requestPanel.getRequest();
        if (uf == null) {
            uf = new URLFetcher[threads];
        }
        idsrequested = (Integer)quantitySpinner.getValue();
        _re = new SessionidUI.RequestEnumeration(request, idsrequested.intValue());

        startButton.setEnabled(false);
        stopButton.setEnabled(true);

        _haltFetchers = false;

        if (_fetcher == null || _fetcher.length < threads) {
            _fetcher = new Fetcher[threads];
        }
        for (int i=0; i<threads; i++) {
            if (_fetcher[i] != null) {
                _fetcher[i].stop();
                _fetcher[i] = null;
            }
            if (_re.hasMoreElements()) {
                _fetcher[i] = new Fetcher(_re);
                new Thread(_fetcher[i]).start();
            }
        }

    }//GEN-LAST:event_startButtonActionPerformed
    
    private void setCookieTableValueChanged(ListSelectionEvent e) {
        //Ignore extra messages.
        if (e.getValueIsAdjusting()) return;
        int row = setCookieTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        log("Selected " + row);
        //        Conversation c = setCookieTableModel.getConversation(row);
        //        Request req = c.getServerRequest();
        //        if (req == null) {
        //            req = c.getClientRequest();
        //            if (req == null) {
        //                log("Error : conversation " + c.getID() + " does not have a request!");
        //                return;
        //            }
        //        }
        //        editRequestTextPane.setText(req.toString("\n"));
        //        editRequestTextPane.setCaretPosition(0);
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField regexTextField;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JComboBox seriesComboBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton exportButton;
    private javax.swing.JTextField dateTextField;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton stopButton;
    private javax.swing.JRadioButton idCookieRadioButton;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JButton testButton;
    private javax.swing.JButton seriesButton;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton idContentRadioButton;
    private javax.swing.ButtonGroup idTypeButtonGroup;
    private javax.swing.JButton startButton;
    private javax.swing.JTextPane responseLogTextPane;
    private javax.swing.JTable setCookieTable;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JSpinner rangeStartSpinner;
    private javax.swing.JList seriesList;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JSpinner rangeStopSpinner;
    private javax.swing.JButton calculateButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSpinner quantitySpinner;
    private javax.swing.JTextField stringTextField;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable valuesTable;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel jLabel5;
    // End of variables declaration//GEN-END:variables
    
    class SessionidTableModel extends AbstractTableModel {
        
        protected int nextEmptyRow = 0;
        protected int numRows = 0;
        
        protected ArrayList data = new ArrayList(1);
        protected String [] columnNames = {
            "Date", "String", "Value"
        };
        
        public SessionidTableModel() {
        }
        
        public synchronized void clear() {
            data.clear();
            fireTableDataChanged();
        }
        
        public synchronized void update(SessionID s) {
            int row=0;
            if (data.contains(s)) {
                row = data.indexOf(s);
                fireTableRowsUpdated(row,row);
            } else {
                data.add(s);
                row = data.size();
                fireTableRowsInserted(row,row);
            }
        }
        
        public SessionID getSessionID(int row) {
            if (row > data.size()) {
                return null;
            }
            return (SessionID) data.get(row);
        }
        
        public String getColumnName(int column) {
            if (column < columnNames.length) {
                return columnNames[column];
            }
            return "";
        }
        
        //XXX Should this really be synchronized?
        public synchronized int getColumnCount() {
            return columnNames.length;
        }
        
        public synchronized int getRowCount() {
            return data.size();
        }
        
        public synchronized Object getValueAt(int row, int column) {
            SessionID s = (SessionID) data.get(row);
            switch (column) {
                case 0:
                    return s.getDate();
                case 1:
                    return s.getValue();
                case 2:
                    return s.getIntValue();
            }
            return "";
        }
        
    }
    
    private class RequestEnumeration implements Enumeration {
        
        private Request _request;
        private int _count;
        
        public RequestEnumeration(Request request, int count) {
            _request = request;
            _count = count;
        }
        
        /** Tests if this enumeration contains more elements.
         *
         * @return  <code>true</code> if and only if this enumeration object
         *           contains at least one more element to provide;
         *          <code>false</code> otherwise.
         *
         */
        public synchronized boolean hasMoreElements() {
            return _count > 0;
        }
        
        /** Returns the next element of this enumeration if this enumeration
         * object has at least one more element to provide.
         *
         * @return     the next element of this enumeration.
         * @exception  NoSuchElementException  if no more elements exist.
         *
         */
        public synchronized Object nextElement() {
            if (hasMoreElements()) {
                _count--;
                return _request;
            } else {
                return null;
            }
        }
    }
    
    private class Fetcher implements Runnable {
        
        private RequestEnumeration _re;
        private boolean _stopped = false;
        
        public Fetcher(RequestEnumeration re) {
            _re = re;
        }
        
        /** When an object implementing interface <code>Runnable</code> is used
         * to create a thread, starting the thread causes the object's
         * <code>run</code> method to be called in that separately executing
         * thread.
         * <p>
         * The general contract of the method <code>run</code> is that it may
         * take any action whatsoever.
         *
         * @see     java.lang.Thread#run()
         *
         */
        public void run() {
            URLFetcher uf = new URLFetcher();
            while (_re.hasMoreElements() && ! _stopped && ! _haltFetchers) {
                Request request = (Request) _re.nextElement();
                if (request == null) {
                    return;
                }
                Response response = uf.fetchResponse(request);
                if (response != null) {
                    boolean valid = false;
                    for (int i=0; i<_fetcher.length; i++) {
                        if (this == _fetcher[i]) {
                            valid = true;
                            continue;
                        }
                    }
                    if (!valid) {
                        return;
                    }
                    response.readContentStream();
                    if (response.getStatus().equals("500")) {
                        _haltFetchers = true;
                    }
                    String cookie = response.getHeader("Set-Cookie");
                    System.out.println("Cookie = '" + cookie + "'");
                    String first = cookie.split(" *; *")[0];
                    System.out.println("First = '" + first +"'");
                    String value = first.split("=")[1];
                    Date date = Util.rfc822(response.getHeader("Date"));
                    updateStatus(value,date);
                } else {
                    log("Got a null response in reply to " + request.getURL());
                }
            }
        }
        
        public void stop() {
            _stopped = true;
        }
    }
    
    
}