/*
 * FileSystemModel2.java
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package za.org.dragon.exodus.plugins.SiteInfo;

import java.io.IOException;
import java.io.File;
import java.util.Date;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeModel;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeModelEvent;

import com.sun.swing.JTreeTable.*;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import za.org.dragon.exodus.URLInfo;
import za.org.dragon.exodus.Model;

import javax.swing.tree.DefaultMutableTreeNode;

public class SiteInfoModel extends AbstractTreeTableModel {
    
    private TreeModel treeModel;
    
    // Names of the columns.
    static protected String[]  cNames = {"URL", "Conversations", "Status", "Cookie Required", "Auth", "App", "Forms", "Comments", "Scripts"};
    
    // Types of the columns.
    static protected Class[]  cTypes = { TreeTableModel.class,
    String.class, String.class,
    Boolean.class,Boolean.class,
    Boolean.class,Boolean.class,
    Boolean.class, Boolean.class};
    
    public SiteInfoModel(TreeModel treeModel) {
        super(treeModel.getRoot());
        this.treeModel = treeModel;
        treeModel.addTreeModelListener(new TreeModelListener() {
            public void treeNodesChanged(TreeModelEvent e) {
                fireTreeNodesChanged(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
            }
            public void treeNodesInserted(TreeModelEvent e) {
                fireTreeNodesInserted(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
            }
            public void treeNodesRemoved(TreeModelEvent e) {
                fireTreeNodesRemoved(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
            }
            public void treeStructureChanged(TreeModelEvent e) {
                fireTreeStructureChanged(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
            }
        });
    }
    
    //
    // The TreeModel interface
    //
    
    /**
     * Returns the number of children of <code>node</code>.
     */
    public int getChildCount(Object node) {
        return treeModel.getChildCount(node);
    }
    
    /**
     * Returns the child of <code>node</code> at index <code>i</code>.
     */
    public Object getChild(Object node, int i) {
        return treeModel.getChild(node,i);
    }
    
    /**
     * Returns true if the passed in object represents a leaf, false
     * otherwise.
     */
    public boolean isLeaf(Object node) {
        return treeModel.isLeaf(node);
    }
    
    /**
     * calls the underlying tree's updateNode method
     */
//    public TreePath updateNode(URLInfo ui) {
//        return treeModel.updateNode(ui);
//    }
    
    //
    //  The TreeTableNode interface.
    //
    
    /**
     * Returns the number of columns.
     */
    public int getColumnCount() {
        return cNames.length;
    }
    
    /**
     * Returns the name for a particular column.
     */
    public String getColumnName(int column) {
        return cNames[column];
    }
    
    /**
     * Returns the class for the particular column.
     */
    public Class getColumnClass(int column) {
        return cTypes[column];
    }
    
    /**
     * Returns the value of the particular column.
     */
    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode     fn = (DefaultMutableTreeNode)node;
        URLInfo ui = (URLInfo)fn.getUserObject();
        
        try {
            switch(column) {
                case 0:
                    return ui.toString();
                    //		return ui == null ? "" : ui.getName();
                case 1:
                    return ui.getProperty("conversations");
                case 2:
                    return ui.getProperty("status");
                case 3:                     // Cookie required
                    return ui.getPropertyAsBoolean("CookieRequired");
                case 4:                     // Auth
                    return ui.getPropertyAsBoolean("authentication");
                case 5:                     // App
                    return ui.getPropertyAsBoolean("application");
                case 6:                     // Forms
                    return ui.getProperty("forms") == null ? Boolean.FALSE : Boolean.TRUE;
                case 7:                     // Comments
                    return ui.getProperty("comments") == null ? Boolean.FALSE : Boolean.TRUE;
                case 8:                     // Scripts
                    return ui.getProperty("scripts") == null ? Boolean.FALSE : Boolean.TRUE;
            }
        } catch  (SecurityException se) { }
        
        return null;
    }
    
    //
    // Some convenience methods.
    //
    
    protected Object[] getChildren(Object node) {
        DefaultMutableTreeNode fn = (DefaultMutableTreeNode)node;
        Object[] children = new Object[fn.getChildCount()];
        for (int i = 0; i<children.length; i++) {
            children[i] = fn.getChildAt(i);
        }
        return children;
    }
    
    
}
