/*
 * URLView.java
 *
 * Created on February 17, 2003, 9:12 PM
 */

package za.org.dragon.exodus.plugins.SiteInfo;

import za.org.dragon.exodus.Model;
import za.org.dragon.exodus.URLInfo;
import za.org.dragon.exodus.Fragment;
import za.org.dragon.exodus.MultiLineCellRenderer;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelEvent;

import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import com.sun.swing.JTreeTable.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.SwingUtilities;

import java.util.logging.Logger;

import java.net.URL;
/**
 *
 * @author  rdawes
 */
public class URLView extends javax.swing.JPanel {
    
    Model model = null;
    URL selected = null;
    Logger logger = Logger.getLogger("za.org.dragon.exodus");
    SiteInfoModel sim = null;
    
    /** Creates new form URLView */
    public URLView(Model model) {
        this.model = model;
        initComponents();
        sim = new SiteInfoModel(model.getSiteTreeModel());
        urlTable = new JTreeTable(sim);
        urlTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        urlTable.getTree().setRootVisible(false);
        urlTable.getTree().setShowsRootHandles(true);

        // Listen for when the selection changes.
        urlTable.getTree().addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                                   urlTable.getTree().getLastSelectedPathComponent();
                if (node == null) return;
                URLInfo ui = (URLInfo) node.getUserObject();
                urlTableSelectionChanged(ui);
            }
        });
        siteInfoScrollPane.setViewportView(urlTable);
        // commentTable.setDefaultRenderer(String.class,new MultiLineCellRenderer());
        // formTable.setDefaultRenderer(String.class,new MultiLineCellRenderer());
        // scriptTable.setDefaultRenderer(String.class,new MultiLineCellRenderer());
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        urlViewSplitPane = new javax.swing.JSplitPane();
        siteInfoScrollPane = new javax.swing.JScrollPane();
        jPanel3 = new javax.swing.JPanel();
        jTabbedPane2 = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        formTable = new javax.swing.JTable();
        jScrollPane3 = new javax.swing.JScrollPane();
        commentTable = new javax.swing.JTable();
        jScrollPane4 = new javax.swing.JScrollPane();
        scriptTable = new javax.swing.JTable();

        setLayout(new java.awt.GridBagLayout());

        urlViewSplitPane.setDividerLocation(250);
        urlViewSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        urlViewSplitPane.setContinuousLayout(true);
        urlViewSplitPane.setMinimumSize(new java.awt.Dimension(10, 10));
        urlViewSplitPane.setName("Site View");
        urlViewSplitPane.setPreferredSize(new java.awt.Dimension(302, 10));
        urlViewSplitPane.setVerifyInputWhenFocusTarget(false);
        siteInfoScrollPane.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        siteInfoScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        siteInfoScrollPane.setMinimumSize(new java.awt.Dimension(22, 200));
        siteInfoScrollPane.setAutoscrolls(true);
        urlViewSplitPane.setTopComponent(siteInfoScrollPane);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        formTable.setModel(new FragmentTableModel(model, "forms"));
        formTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        formTable.setColumnSelectionAllowed(true);
        jScrollPane1.setViewportView(formTable);

        jTabbedPane2.addTab("Forms", jScrollPane1);

        commentTable.setModel(new FragmentTableModel(model, "comments"));
        commentTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jScrollPane3.setViewportView(commentTable);

        jTabbedPane2.addTab("Comments", jScrollPane3);

        scriptTable.setModel(new FragmentTableModel(model, "scripts"));
        scriptTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jScrollPane4.setViewportView(scriptTable);

        jTabbedPane2.addTab("Scripts", jScrollPane4);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jTabbedPane2, gridBagConstraints);

        urlViewSplitPane.setBottomComponent(jPanel3);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(urlViewSplitPane, gridBagConstraints);

    }//GEN-END:initComponents

    private void urlTableSelectionChanged(URLInfo ui) {
        selected = ui.getURL();
        ((FragmentTableModel)scriptTable.getModel()).setURLInfo(ui);
        ((FragmentTableModel)formTable.getModel()).setURLInfo(ui);
        ((FragmentTableModel)commentTable.getModel()).setURLInfo(ui);
    }
    
    private com.sun.swing.JTreeTable.JTreeTable urlTable;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable commentTable;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane siteInfoScrollPane;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTable scriptTable;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JTable formTable;
    private javax.swing.JTabbedPane jTabbedPane2;
    private javax.swing.JSplitPane urlViewSplitPane;
    private javax.swing.JScrollPane jScrollPane3;
    // End of variables declaration//GEN-END:variables
    
}

class FragmentTableModel extends AbstractTableModel {
    protected Model model = null;
    protected String shpp = null;
    protected String fragmentType = null;
    protected URLInfo ui = null;
    protected String [] columnNames = {
        "Conversation", "Body", "Action", "Comment"
    };
    protected Vector data = null;

    public FragmentTableModel(Model model, String fragmentType) {
        this.model = model;
        this.fragmentType = fragmentType;
    }
    
    public void setURLInfo(URLInfo ui) {
        this.ui = ui;
        data = new Vector(1);
        String[] values = null;
        Fragment[] fragments = null;
        if (fragmentType.equalsIgnoreCase("forms")) {
            values = ui.getPropertyAsArray("forms");
        } else if (fragmentType.equalsIgnoreCase("scripts")) {
            values = ui.getPropertyAsArray("scripts");
        } else if (fragmentType.equalsIgnoreCase("comments")) {
            values = ui.getPropertyAsArray("comments");
        }
        if (values != null && values.length > 0) {
            fragments = new Fragment[values.length];
            for (int j=0; j<values.length; j++) {
                String con = values[j].split(":")[0];
                Fragment frag = Fragment.get(values[j].split(":")[1]);
                Vector row = new Vector(2);
                row.add(con);
                row.add(frag);
                data.add(row);
            }
        }
        fireTableDataChanged();
    }

    public String getColumnName(int column) {
        if (column < columnNames.length) {
            return columnNames[column];
        }
        return "";
    }

    //XXX Should this really be synchronized?
    public synchronized int getColumnCount() {
        return columnNames.length;
    }

    public synchronized int getRowCount() {
        if (data == null) {
            return 0;
        } else {
            return data.size();
        }
    }

    public synchronized Object getValueAt(int row, int column) {
        if (data == null) {
            System.out.println("Trying to get data for an empty table! [" + row + "," + column + "]");
            return "";
        }
        Vector rowdata = (Vector) data.get(row);
        String id = (String) rowdata.get(0);
        Fragment fragment = (Fragment) rowdata.get(1);
	try {
            switch (column) {
                case 0:                     // Conversation
                    return id;
                case 1:                     // Fragment Body
                    return fragment.getBody();
                case 2:                     // Action
                    return fragment.getStatus();
                case 3:                     // Comment
                    return fragment.getComment();
            }
	} catch (Exception e) {
            System.out.println("Got an exception in FragmentTableModel!");
            System.out.println("Looking up [" + row + "," + column + "]");
            System.out.println(e);
	}
	return "";
    }
    
    public synchronized void tableUpdated() {
        fireTableDataChanged();
    }
    
    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }
    
}