/*
 * SpiderConfig.java
 *
 * Created on April 14, 2003, 9:26 PM
 */

package za.org.dragon.exodus.plugins.Spider;

import za.org.dragon.exodus.Exodus;
import java.util.Properties;

/**
 *
 * @author  rdawes
 */
public class SpiderConfig extends javax.swing.JPanel {
    
    private Exodus exodus;
    
    /** Creates new form SpiderConfig */
    public SpiderConfig(Exodus exodus) {
        initComponents();
        this.exodus = exodus;
        Properties props = exodus.getProperties();
        
        try {
            threadSpinner.setValue(new Integer(props.getProperty("SpiderPlugin.threads")));
        } catch (NumberFormatException nfe) {
            threadSpinner.setValue(new Integer(1));
        }
    }
    
    public String acceptConfig(boolean commit) {
        Properties props = exodus.getProperties();
        String value = threadSpinner.getValue().toString();
        String prop = "SpiderPlugin.threads";
        try {
            int p = Integer.parseInt(value);
            if (p <1 || p>32) {
                return new String("Threads must be between 1 and 32");
            }
            if (commit && !value.equals(props.getProperty(prop))) {
                props.setProperty(prop, value);
            }
        } catch (NumberFormatException nfe) {
            return new String("Error parsing the number of threads");
        }
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        threadSpinner = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Threads");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jLabel1, gridBagConstraints);

        threadSpinner.setValue(new Integer(4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(threadSpinner, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jLabel2, gridBagConstraints);

    }//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSpinner threadSpinner;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
}
