/*
 * ConversationPlugin.java
 *
 * Created on March 29, 2003, 10:31 AM
 */

package za.org.dragon.exodus.plugins.Spider;

import za.org.dragon.exodus.Exodus;
import za.org.dragon.exodus.BackingStore;

import java.util.Properties;
import java.util.Enumeration;

/**
 *
 * @author  rdawes
 */
public class SpiderPlugin extends za.org.dragon.exodus.NullPlugin {

    private Exodus _exodus;
    private SpiderUI _ui = null;
    private SpiderConfig _config = null;
    private Properties _props = new Properties();
    
    /** Creates a new instance of SpiderPlugin */
    public SpiderPlugin() {
    }
    
    public void init(Exodus exodus) {
        _exodus = exodus;
        _props.setProperty("SpiderPlugin.threads", "4");
        configure(_props);
    }
    
    public void setProperties(Properties properties) {
        // This just allows us to copy our defaults over into
        // the main properties class, if they are not set already
        Enumeration propnames = _props.keys();
        while (propnames.hasMoreElements()) {
            String key = (String) propnames.nextElement();
            String value = properties.getProperty(key);
            if (value == null) {
                properties.setProperty(key,_props.getProperty(key));
            }
        }
        _props = properties;
        configure(properties);
    }
    
    private void configure(Properties properties) {
        if (_ui != null) {
            _ui.configure(properties);
        }
        
    }

    public String getPluginName() {
        return new String("Spider");
    }
    
    public javax.swing.JPanel createMainInterface() {
        if (_ui == null) {
            _ui = new SpiderUI(_exodus.getModel());
        }
        return _ui;
    }

    public javax.swing.JPanel createConfigInterface() {
        if (_config == null) {
            _config = new SpiderConfig(_exodus);
        }
        return _config;
    }

    public String acceptConfig(boolean commit) {
        if (_config != null) {
            return _config.acceptConfig(commit);
        }
        return null;
    }
    
}
