/*
 * SpiderUI.java
 *
 * Created on March 10, 2003, 10:48 PM
 */

package za.org.dragon.exodus.plugins.Spider;

import za.org.dragon.exodus.*;

import java.net.URL;
import java.net.MalformedURLException;

import javax.swing.JFrame;
import java.io.IOException;
import java.util.Observable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.DefaultComboBoxModel;

import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;

import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;

import java.util.Properties;
import java.util.Enumeration;
import java.util.logging.Logger;


/**
 *
 * @author  rdawes
 */
public class SpiderUI extends javax.swing.JPanel {
    
    private Model model;
    private MessageLog messageLog;
    private TreeModel webtree;
    private URLInfo selected = null;
    private UnseenRenderer cellRenderer;
    private DefaultComboBoxModel cookieComboBoxModel;
    private int threads = 4;
    private Fetcher[] _fetcher;
    private Vector targets;
    private Properties props = null;
    
    private boolean _haltFetchers = false;
    private Logger _logger = Logger.getLogger("za.org.dragon.exodus");
    SpiderUI.RequestEnumeration _re = null;
    
    /** Creates new form SpiderUI */
    public SpiderUI(Model model) {
        this.model = model;
        initComponents();
        webtree = model.getSiteTreeModel();
        siteTree.setModel(webtree);
        siteTree.getSelectionModel().setSelectionMode
        (TreeSelectionModel.SINGLE_TREE_SELECTION);
        siteTree.setRootVisible(false);
        siteTree.setShowsRootHandles(true);
        
        //Listen for when the selection changes.
        siteTree.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                siteTree.getLastSelectedPathComponent();
                if (node == null) return;
                selected = (URLInfo)node.getUserObject();
            }
        });
        cellRenderer = new UnseenRenderer();
        siteTree.setCellRenderer(cellRenderer);
    }
    
    public void configure(Properties props) {
        String prop = "SpiderPlugin.threads";
        String threadString = props.getProperty(prop);
        try {
            threads = Integer.parseInt(props.getProperty(prop));
        } catch (NumberFormatException nfe) {
            System.out.println("Error parsing " + prop + " from properties");
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        siteTree = new javax.swing.JTree();
        jLabel3 = new javax.swing.JLabel();
        cookieComboBoxModel = new DefaultComboBoxModel();
        cookieComboBoxModel.addElement("");
        cookieNameComboBox = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        newHeaderButton = new javax.swing.JButton();
        deleteHeaderButton = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        headerTable = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        logTextArea = new javax.swing.JTextArea();
        spiderThisButton = new javax.swing.JButton();
        spiderTheseButton = new javax.swing.JButton();
        spiderCancelButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setResizeWeight(0.8);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setMinimumSize(new java.awt.Dimension(22, 200));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(81, 600));
        siteTree.setToolTipText("Select an URL as indicated by the tree. Then select additional request headers, and cookies to use. Then hit \\\"fetch\\\" or \\\"fetch all\\\" to start.");
        jScrollPane1.setViewportView(siteTree);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        jLabel3.setText("Cookies");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel1.add(jLabel3, gridBagConstraints);

        cookieNameComboBox.setModel(cookieComboBoxModel);
        cookieNameComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cookieNameComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(cookieNameComboBox, gridBagConstraints);

        jSplitPane1.setLeftComponent(jPanel1);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setPreferredSize(new java.awt.Dimension(523, 400));
        jLabel2.setText("Request Headers");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jLabel2, gridBagConstraints);

        newHeaderButton.setText("Add");
        newHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newHeaderButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weighty = 0.0010;
        jPanel2.add(newHeaderButton, gridBagConstraints);

        deleteHeaderButton.setText("Delete");
        deleteHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteHeaderButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 0.0010;
        jPanel2.add(deleteHeaderButton, gridBagConstraints);

        jScrollPane3.setMaximumSize(new java.awt.Dimension(32767, 100));
        jScrollPane3.setMinimumSize(new java.awt.Dimension(22, 100));
        jScrollPane3.setPreferredSize(new java.awt.Dimension(453, 150));
        headerTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Value"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        headerTable.setPreferredScrollableViewportSize(new java.awt.Dimension(450, 300));
        headerTable.setPreferredSize(null);
        jScrollPane3.setViewportView(headerTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jScrollPane3, gridBagConstraints);

        jScrollPane2.setViewportBorder(new javax.swing.border.TitledBorder("Log"));
        jScrollPane2.setMinimumSize(new java.awt.Dimension(100, 64));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(100, 64));
        logTextArea.setBackground(new java.awt.Color(204, 204, 204));
        logTextArea.setMinimumSize(new java.awt.Dimension(0, 64));
        jScrollPane2.setViewportView(logTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane2, gridBagConstraints);

        jSplitPane1.setRightComponent(jPanel2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jSplitPane1, gridBagConstraints);

        spiderThisButton.setText("Fetch");
        spiderThisButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                spiderThisButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        add(spiderThisButton, gridBagConstraints);

        spiderTheseButton.setText("Fetch All");
        spiderTheseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                spiderTheseButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        add(spiderTheseButton, gridBagConstraints);

        spiderCancelButton.setText("Stop");
        spiderCancelButton.setEnabled(false);
        spiderCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                spiderCancelButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(spiderCancelButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void spiderCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_spiderCancelButtonActionPerformed
        _haltFetchers = true;
        for (int i=0; i<threads; i++) {
            if (_fetcher[i] != null) {
                _fetcher[i].stop();
                _fetcher[i] = null;
            }
        }
        spiderThisButton.setEnabled(true);
        spiderTheseButton.setEnabled(true);
        spiderCancelButton.setEnabled(false);
    }//GEN-LAST:event_spiderCancelButtonActionPerformed
    
    private void spiderTheseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_spiderTheseButtonActionPerformed
        if (selected == null) {
            _logger.warning("No URL selected! Please select part of the web space to spider!");
            return;
        }
        String root = selected.getURL().toString();
        Vector unseen = new Vector();
        String[] urls = model.getURLs();
        for (int i=0; i<urls.length; i++) {
            if (urls[i].startsWith(root) && (model.getURLInfo(urls[i]).getProperty("conversations")==null)) {
                unseen.add(urls[i]);
            }
        }
        _haltFetchers = false;
        fetch(unseen);
	}//GEN-LAST:event_spiderTheseButtonActionPerformed
    
    private void fetch(Vector targets) {
        if (targets != null && targets.size() >0) {
            String[][] headers = getHeaders();
            _re = new SpiderUI.RequestEnumeration(targets, headers);
        
            spiderThisButton.setEnabled(false);
            spiderTheseButton.setEnabled(false);
            spiderCancelButton.setEnabled(true);

            if (_fetcher == null || _fetcher.length < threads) {
                _fetcher = new Fetcher[threads];
            }
            for (int i=0; i<threads; i++) {
                if (_fetcher[i] != null) {
                    _fetcher[i].stop();
                    _fetcher[i] = null;
                }
                if (_re.hasMoreElements()) {
                    _fetcher[i] = new Fetcher(_re);
                    new Thread(_fetcher[i]).start();
                }
            }
        } else {
            _logger.warning("No URL's left to fetch");
        }
    }
        
    private void cookieNameComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cookieNameComboBoxActionPerformed
        if (cookieNameComboBox.getSelectedIndex()>0) {
            if (cookieNameComboBox.getSelectedItem() != null) {
                //                log("Selected cookie '" + cookieNameComboBox.getSelectedItem() + "'");
                //                cellRenderer.setCookie((Cookie)cookieNameComboBox.getSelectedItem());
                //                webtree.fire something
                addHeader((Cookie)cookieNameComboBox.getSelectedItem());
            } else {
                //                log("Selected a null cookie");
                //                cellRenderer.setCookie(null);
            }
        } else {
            //            log("Selected a null cookie");
            //            cellRenderer.setCookie(null);
        }
    }//GEN-LAST:event_cookieNameComboBoxActionPerformed
    
    private void addHeader(Cookie cookie) {
        DefaultTableModel tablemodel = (DefaultTableModel)headerTable.getModel();
        int rows = headerTable.getRowCount();
        if (rows > 0) {
            boolean added = false;
            for (int i=0; i<rows; i++) {
                if (tablemodel.getValueAt(i, 0).equals("Cookie")) {
                    String value = (String)tablemodel.getValueAt(i, 1);
                    tablemodel.setValueAt(cookie.getName() + "=" + cookie.getValue(), i, 1);
                    added = true;
                    break;
                }
            }
            if (!added) {
                tablemodel.addRow(new Object[] {"Cookie",cookie.getName() + "=" + cookie.getValue()});
            }
        } else {
            tablemodel.addRow(new Object[] {"Cookie",cookie.getName() + "=" + cookie.getValue()});
        }
    }
    
    private void deleteHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteHeaderButtonActionPerformed
        if (headerTable.getSelectedRow()>-1) {
            ((DefaultTableModel)headerTable.getModel()).removeRow(headerTable.getSelectedRow());
        }
    }//GEN-LAST:event_deleteHeaderButtonActionPerformed
    
    private void newHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newHeaderButtonActionPerformed
        if (headerTable.getSelectedRow()>-1) {
            ((DefaultTableModel)headerTable.getModel()).insertRow(headerTable.getSelectedRow()+1,new Object[] { null, null} );
        } else {
            ((DefaultTableModel)headerTable.getModel()).addRow(new Object[] {null,null});
        }
    }//GEN-LAST:event_newHeaderButtonActionPerformed
    
    private void spiderThisButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_spiderThisButtonActionPerformed
        if (selected == null) {
            _logger.warning("No URL selected! Please select part of the web space to spider!");
            return;
        }
        String root = selected.getURL().toString();
        Vector v = new Vector(1);
        v.add(root);
        _haltFetchers = false;
        fetch(v);
    }//GEN-LAST:event_spiderThisButtonActionPerformed
    
    private String[][] getHeaders() {
        String[][] header = new String[headerTable.getModel().getRowCount()][2];
        for (int i = 0; i<headerTable.getModel().getRowCount(); i++) {
            header[i][0] = (String)headerTable.getModel().getValueAt(i, 0);
            header[i][1] = (String)headerTable.getModel().getValueAt(i, 1);
        }
        return header;
    }
    
    private synchronized void updateStatus(final String message) {
        SwingWorker sw = new SwingWorker() {
            public Object construct() { return null; }
            
            public void finished() {
                synchronized(logTextArea) {
                    logTextArea.append(message + "\n");
                    logTextArea.setCaretPosition(logTextArea.getText().length());
                }
                if (!_re.hasMoreElements() || _haltFetchers) {
                    spiderThisButton.setEnabled(true);
                    spiderTheseButton.setEnabled(true);
                }
            }
        };
        sw.start();
    }
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton spiderCancelButton;
    private javax.swing.JButton deleteHeaderButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JComboBox cookieNameComboBox;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTable headerTable;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton spiderTheseButton;
    private javax.swing.JButton newHeaderButton;
    private javax.swing.JTextArea logTextArea;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTree siteTree;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JButton spiderThisButton;
    // End of variables declaration//GEN-END:variables

    private class RequestEnumeration implements Enumeration {
        
        private Vector _targets;
        private String[][] _headers;
        private int _index = 0;
        
        public RequestEnumeration(Vector targets, String[][] headers) {
            _targets = targets;
            _headers = headers;
            _index = 0;
        }
        
        /** Tests if this enumeration contains more elements.
         *
         * @return  <code>true</code> if and only if this enumeration object
         *           contains at least one more element to provide;
         *          <code>false</code> otherwise.
         *
         */
        public synchronized boolean hasMoreElements() {
            return _index < _targets.size();
        }
        
        /** Returns the next element of this enumeration if this enumeration
         * object has at least one more element to provide.
         *
         * @return     the next element of this enumeration.
         * @exception  NoSuchElementException  if no more elements exist.
         *
         */
        public synchronized Object nextElement() {
            if (hasMoreElements()) {
                Request request = new Request();
                request.setMethod("GET");
                String url = (String)_targets.get(_index);
                try {
                    request.setURL(url);
                } catch (MalformedURLException mue) {
                    _logger.severe("Malformed URL! " + url + " - " + mue);
                    _index++;
                    return null;
                }
                request.setVersion("HTTP/1.1");
                request.setHeaders(_headers);
                _index ++;
                return request;
            }
            return null;
        }
    }
    
    class UnseenRenderer extends DefaultTreeCellRenderer {
        
        private Cookie cookie = null;
        
        public UnseenRenderer() {
            //        tutorialIcon = new ImageIcon("images/middle.gif");
        }
        
        public void setCookie(Cookie cookie) {
            this.cookie = cookie;
        }
        
        public Component getTreeCellRendererComponent(
        JTree tree,
        Object value,
        boolean sel,
        boolean expanded,
        boolean leaf,
        int row,
        boolean hasFocus) {
            
            super.getTreeCellRendererComponent(
            tree, value, sel,
            expanded, leaf, row,
            hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
            URLInfo ui = (URLInfo) node.getUserObject();
            if (ui != null && ! hasFocus) {
                boolean seen = true;
                String conversations = ui.getProperty("conversations");
                if (conversations == null) {
                    seen = false;
                    setBackground(Color.LIGHT_GRAY);
                    setOpaque(true);
                } else if (cookie != null) {
                    setBackground(Color.LIGHT_GRAY);
                    setOpaque(true);
                } else {
                    setOpaque(false);
                }
            } else {
                setOpaque(false);
            }
            return this;
        }
    }
    
    private class Fetcher implements Runnable {

        private RequestEnumeration _re;
        private boolean _stopped = false;
        
        public Fetcher(RequestEnumeration re) {
            _re = re;
        }
        
        /** When an object implementing interface <code>Runnable</code> is used
         * to create a thread, starting the thread causes the object's
         * <code>run</code> method to be called in that separately executing
         * thread.
         * <p>
         * The general contract of the method <code>run</code> is that it may
         * take any action whatsoever.
         *
         * @see     java.lang.Thread#run()
         *
         */
        public void run() {
            URLFetcher uf = new URLFetcher();
            while (_re.hasMoreElements() && ! _stopped && ! _haltFetchers) {
                Request request = (Request) _re.nextElement();
                if (request == null) {
                    return;
                }
                Response response = uf.fetchResponse(request);
                if (response != null) {
                    boolean valid = false;
                    for (int i=0; i<_fetcher.length; i++) {
                        if (this == _fetcher[i]) {
                            valid = true;
                            continue;
                        }
                    }
                    if (!valid) {
                        return;
                    }
                    response.readContentStream();
                    String conversationID = model.newConversationID();
                    model.setServerRequest(conversationID, request);
                    model.setServerResponse(conversationID,  response);
                    model.setOrigin(conversationID, "Spider");
                    if (response.getStatus().equals("500")) {
                        _haltFetchers = true;
                    }
                    updateStatus(request.getMethod() + " " + request.getURL() + " : " + response.getStatusLine());
                } else {
                    _logger.warning("Got a null response in reply to " + request.getURL());
                }
            }
        }
        
        public void stop() {
            _stopped = true;
        }
    }
}

