#!/usr/bin/perl -w

use strict;
use Math::BigInt ':constant';

my $verbose=1;

my %chars=();

my @charpos=();

my @cookies=();

while (my $line=<>) {
  chomp $line;
  push @cookies,$line;
  my @line=split('',$line);
  for (my $i=0; $i<length($line); $i++) {
    my $char=$line[$i];
    if (! exists $chars{$char} ) {
      $chars{$char}=1;
    } else {
      $chars{$char}++;
    }
    if (!exists $charpos[$i]->{$char}) {
      $charpos[$i]->{$char}=1;
    } else {
      $charpos[$i]->{$char}++;
    }
  }
}

if ($verbose) {
  my @chars=sort keys %chars;
  print "Overall Charset count is : ",$#chars+1,"\n";
  print "Overall Charset is : \n";
  print join('',sort keys %chars),"\n";
  
  print "\nOverall Distribution is :\n";

  foreach my $char (sort keys %chars) {
    print "$char : ",$chars{$char},"\n";
  }
}


my @charset=();

if ($verbose) { print "\n\nPositional distribution is as follows:\n\n\n"; }

for (my $i=0; $i<=$#charpos; $i++) {
  my $chars=$charpos[$i];
  my @chars=sort keys %$chars;
  $charset[$i]=join('',sort keys %$chars);

  if ($verbose) {
    print "Position $i Charset count is : ",$#chars+1,"\n";
    print "Charset is : \n";
    print $charset[$i],"\n";
  
    print "\nDistribution is :\n";
  
    foreach my $char (sort keys %$chars) {
      print "$char : ",$chars->{$char},"\n";
    }
    print "\n\n\n\n";
  }

}

my $prev=Math::BigInt->new("0");

while (my $cookie=shift @cookies) {
  my $value=undef;
  my $base=undef;
  my $total=Math::BigInt->new("0");

  for ( my $p=0; $p < length($cookie); $p++) {
    if (defined $base) { $total*=$base; }
    ($value,$base)=charval(substr($cookie,$p,1),$charset[$p]);
    $total+=$value;
  }
  print $cookie," : ",$total," : ",($total-$prev),"\n";
  $prev=$total;
}

exit;


sub charval {
  my $char=shift;
  my $charset=shift;

  return (index($charset,$char),length($charset));
}
