#!/usr/bin/perl -w
# vim600: set foldmethod=marker: 

#
# This is the basis of an application with signal handlers
#
# You can safely edit this file, any changes that you make will be preserved
# and this file will not be overwritten by the next run of Glade::PerlGenerate
#
# Skeleton subs of any missing signal handlers can be copied from
# /home/rdawes/source/mangle/exodus2/src/ExodusSIGS.pm
#
#==============================================================================
#=== This is the 'Exodus' class                              
#==============================================================================
package Exodus;
require 5.000;
use strict 'vars', 'refs', 'subs';

# UI class 'Exodus' (version 0.01)
# 
# Copyright (c) Date Thu Nov  7 23:04:40 SAST 2002
# Author  <rdawes\@rdawes.deloitte.co.za>
#
## Unspecified copying policy, please contact the author\n#   <rdawes\@rdawes.deloitte.co.za>
#
#==============================================================================
# This perl source file was automatically generated by 
# Glade::PerlGenerate version 0.59 - Wed Jun 20 14:48:25 BST 2001
# Copyright (c) Author Dermot Musgrove <dermot.musgrove\@virgin.net>
#
# from Glade file /home/rdawes/source/mangle/exodus2/exodus.glade
# Thu Nov  7 23:21:40 SAST 2002
#==============================================================================

BEGIN {
    use src::ExodusUI;
    use src::treewindow;
    use URI;
    use HTML::LinkExtor;
    use Data::Dumper;
    eval { 
      local $SIG{'__DIE__'}; 
      require Gtk::XmHTML;
    };
    if ($@) {
      $__PACKAGE__::XmHTML=0; 
    } else { 
      $__PACKAGE__::XmHTML=1; 
    }
    # Temporarily disabled until we can fix this! FIXME
    $__PACKAGE__::XmHTML=0;

    @__PACKAGE__::piduri  = (); # maps PID to URI
    %__PACKAGE__::urlpids = (); # maps URL to the PIDs where they were requested
    %__PACKAGE__::treenode = ();   # maps URL to the actual tree node holding it
    @__PACKAGE__::logrow   = ();   # maps PID to the logtable row holding it
    %__PACKAGE__::urldata  = ();   # contains whatever we know about an URL
    @__PACKAGE__::logfiles = ( 'log', 'analyse' );
    %__PACKAGE__::logfiles = ();   # contains handles for logfiles that we read
    $__PACKAGE__::timer    = '';   # used to trigger reading of files
    $__PACKAGE__::requestdetails = 0; # used to prevent multiple clearing

    $__PACKAGE__::trace=0;
    $SIG{__DIE__} = sub { require Carp; Carp::confess(@_) };

}    # End of sub BEGIN

sub app_run {    #{{{
    my $class  = shift;
    my $params = shift;

    if ( defined $params->{'datadir'} ) {
        $__PACKAGE__::datadir = $params->{'datadir'};
        if ( substr( $__PACKAGE__::datadir, -1 ) ne '/' ) {
            $__PACKAGE__::datadir .= '/';
        }
    } else {
        die "You must supply a directory to read the input data from!\n";
    }
    if ( !-d $__PACKAGE__::datadir ) {
        die "Directory '" . $__PACKAGE__::datadir . "' does not exist\n";
    }
    if ( !-f $__PACKAGE__::datadir . 'log' ) {
        die "Logfile '" . $__PACKAGE__::datadir . "log' does not exist\n";
    }

    $class->load_translations('Exodus');

    # You can use the line below to load a test .mo file before it is installed in 
    # the normal place (eg /usr/local/share/locale/en_US/LC_MESSAGES/Exodus.mo)
    #    $class->load_translations('Exodus', 'test', undef, '/home/rdawes/source/mangle/exodus2/ppo/Exodus.mo');
    Gtk->init;
    my $window = $class->new;
    if ($__PACKAGE__::XmHTML) {
      my $html=Gtk::XmHTML->new();
      $window->{'FORM'}->{'responseHTMLWindow'}->add_with_viewport($html);
      $window->{'FORM'}->{'responseHTML'}=$html;
      $html->source('<HTML></HTML>');
      $html->set_image_procs(\&getimage);
#      This causes a segmentation fault FIXME
#      $html->show;
    } else {
      my $label=Gtk::Label->new("Please install Gtk::XmHTML");
      $label->set_justify("center");
      $label->show;
      $window->{'FORM'}->{'responseHTMLWindow'}->add_with_viewport($label);
      $window->{'FORM'}->{'responseHTML'}=$label;
    }
    $window->TOPLEVEL->show;

    # This makes the toplevel window available to the whole app.
    # Probably are better ways of doing this :-(
    $__PACKAGE__::window = $window;

    # Put any extra UI initialisation (eg signal_connect) calls here

    define_urltree( $window, 'treeWindow' );

    # we define some colors that we use
    $__PACKAGE__::color{"FOREGROUND"}  = Gtk::Gdk::Color->parse_color('black');
    $__PACKAGE__::color{"DESCRIPTION"} = Gtk::Gdk::Color->parse_color('red');
    $__PACKAGE__::color{"SEEN"}        = Gtk::Gdk::Color->parse_color('white');
    $__PACKAGE__::color{"UNSEEN"}      = Gtk::Gdk::Color->parse_color('bisque');

    # set up the timer
    foreach my $logfile (@__PACKAGE__::logfiles) {
      my $fh;
      if ( ! -r $__PACKAGE__::datadir.$logfile) {
        warn "Can't read '$logfile' : $!\n";
      } else {
        open( $fh,$__PACKAGE__::datadir.$logfile)
          || warn "Couldn't open '$logfile' : $!\n";
      }
      $__PACKAGE__::logfiles{$logfile}=$fh;
    }
    my $form = $__PACKAGE__::all_forms->{$window->INSTANCE};
    my $statusbar=$form->{'statusbar'};
    my $context=$statusbar->get_context_id( 'Loading' );
    $statusbar->push($context,"Reading from logfile");
    Gtk->main_iteration while ( Gtk->events_pending );
    tail_log($window->INSTANCE);
    $statusbar->pop($context);
    
    $__PACKAGE__::timer =
      Gtk->timeout_add( 500, \&tail_log, $window->INSTANCE );

    # Now let Gtk handle signals
    Gtk->main;

    $window->TOPLEVEL->destroy;

    return $window;

}    # End of sub app_run#}}}

sub getimage {
  my ($widget, $href) = @_;
  my @gif=(0x47,0x49,0x46,0x38,
           0x39,0x61,0x01,0x00,
           0x01,0x00,0x80,0x00,
           0x00,0xff,0xff,0xff,
           0x00,0x00,0x00,0x21,
           0xf9,0x04,0x01,0x00,
           0x00,0x00,0x00,0x2c,
           0x00,0x00,0x00,0x00,
           0x01,0x00,0x01,0x00,
           0x00,0x02,0x02,0x44,
           0x01,0x00,0x3b,0x00,
          );
  print STDERR "Ignoring request for '$href'\n";
  return ($href,join('',@gif));
}

#===============================================================================
#=== Below are the default signal handlers for 'Exodus' class
#===============================================================================
sub about_Form {    #{{{
    my ($class) = @_;
    my $gtkversion =
      Gtk->major_version . "." . Gtk->minor_version . "." . Gtk->micro_version;
    my $name    = $0;
    my $message =
      __PACKAGE__ . " ("
      . _("version")
      . " $VERSION - $DATE)\n"
      . _("Written by")
      . " $AUTHOR \n\n"
      . _("No description") . " \n\n" . "Gtk "
      . _("version")
      . ": $gtkversion\n"
      . "Gtk-Perl "
      . _("version")
      . ": $Gtk::VERSION\n"
      . _("run from file")
      . ": $name";
    __PACKAGE__->message_box(
        $message,
        _("About") . " \u" . __PACKAGE__,
        [ _('Dismiss'), _('Quit Program') ],
        1,
        "$Glade::PerlRun::pixmaps_directory/glade2perl_logo.xpm",
        'left'
    );
}    # End of sub about_Form#}}}

sub destroy_Form {    #{{{
    my ( $class, $data, $object, $instance ) = @_;
    print STDERR "in destroy_Form\n";
    Gtk->main_quit;
}    # End of sub destroy_Form#}}}

sub toplevel_hide    { shift->get_toplevel->hide }
sub toplevel_close   { shift->get_toplevel->close }
sub toplevel_destroy { shift->get_toplevel->destroy }

#==============================================================================
#=== Below are the signal handlers for 'Exodus' class 
#==============================================================================
sub on_Exodus_check_resize {    #{{{
    my ( $class, $data, $object, $instance, $event ) = @_;
    my $me = __PACKAGE__ . "->on_Exodus_check_resize";

    # Get ref to hash of all widgets on our form
#    my $form = $__PACKAGE__::all_forms->{$instance};

#    print STDERR "on_Exodus_check_resize called!\n";

}    # End of sub on_Exodus_check_resize#}}}

sub on_Exodus_destroy {    #{{{
#  This line is commented out because it causes an error
#  "Attempt to free unreferenced scalar"
#    my ( $class, $data, $object, $instance, $event ) = @_;
#    my $me = __PACKAGE__ . "->on_Exodus_destroy";
  
    # Get ref to hash of all widgets on our form
#    my $form = $__PACKAGE__::all_forms->{$instance};

    Gtk->main_quit;

}    # End of sub on_Exodus_destroy#}}}

sub on_Exodus_size_request {    #{{{
    my ( $class, $data, $object, $instance, $event ) = @_;
    my $me = __PACKAGE__ . "->on_Exodus_size_request";

    # Get ref to hash of all widgets on our form
#    my $form = $__PACKAGE__::all_forms->{$instance};

#    print STDERR "on_Exodus_size_request called!\n";

}    # End of sub on_Exodus_size_request#}}}

sub on_descriptionEntry_activate {    #{{{
    my ( $class, $data, $object, $instance, $event ) = @_;
    my $me = __PACKAGE__ . "->on_descriptionEntry_activate";

    # Get ref to hash of all widgets on our form
    my $form     = $__PACKAGE__::all_forms->{$instance};
    my $logtable = $form->{"logViewClist"};
    my $field    = $form->{"descriptionEntry"};

    my $pid = $__PACKAGE__::logViewClistSelection;

    my $description=$field->get_text();
    if ( $description ) {
        $logtable->set_foreground( $__PACKAGE__::logrow[$pid],
            $__PACKAGE__::color{"DESCRIPTION"} );
    } else {
        $logtable->set_foreground( $__PACKAGE__::logrow[$pid],
            $__PACKAGE__::color{"FOREGROUND"} );
    }
    writedescription($pid,$description);

}    # End of sub on_descriptionEntry_activate#}}}

sub on_logViewClist_select_row {    #{{{
    my ( $self, $data, $name, $instance, $row, $column ) = @_;
    my $seq = $self->get_text( $row, 0 );

    $__PACKAGE__::logViewClistSelection = $seq;

    # FIXME: Also select the node in the tree, and the relevant requestClist row, and hence the details
    show_request_details( $instance, $seq );

}    # End of sub on_logViewClist_select_row#}}}

sub on_logViewClist_unselect_row {    #{{{
    my ( $self, $data, $name, $instance, $row, $column ) = @_;
    my $seq  = $self->get_text( $row, 0 );
    my $form = $__PACKAGE__::all_forms->{$instance};

#    print STDERR "on_logViewClist_unselect_row\n";
    clear_request_details( $instance, $seq );
#    $form->{"urltree"}->unselect;
    clear_requestClist( $instance,    $seq );

}    # End of sub on_logViewClist_unselect_row#}}}

sub on_requestClist_select_row {    #{{{
    my ( $self, $data, $name, $instance, $row, $column ) = @_;
    my $me = __PACKAGE__ . "->on_requestClist_select_row";

    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};
    my $seq  = $self->get_text( $row, 0 );

    # Show the actual request highlighted in the logview clist FIXME
    show_request_details( $instance, $seq );

}    # End of sub on_requestClist_select_row#}}}

sub on_requestClist_unselect_row {    #{{{
    my ( $self, $data, $name, $instance, $row, $column ) = @_;
    my $me = __PACKAGE__ . "->on_requestClist_unselect_row";

#    print STDERR "on_requestClist_unselect_row\n";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};
    my $seq  = $self->get_text( $row, 0 );

    # FIXME Clear the logview selected clist entry
    clear_request_details( $instance, $seq );
#    $form->{"logviewClist"}->unselect;

#    print STDERR "on_requestClist_unselect_row\n";

}    # End of sub on_requestClist_unselect_row#}}}

sub on_urltree_select_row {    #{{{
    my ( $self, $data, $name, $instance, $row, $column ) = @_;

    my $node = $self->node_nth($row);
    my $url  = $self->node_get_text( $node, 0 );

    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

    # FIXME - clear the logview selected entry if any
    # FIXME - clear the details of any selected request
    clear_requestClist($instance);
    if ( exists $__PACKAGE__::urlpids{$url} ) {
        show_requestClist( $instance, $url );
    }

}    # End of sub on_urltree_select_row#}}}

sub on_urltree_unselect_row {    #{{{
    my ( $class, $data, $object, $instance, $event ) = @_;
    my $me = __PACKAGE__ . "->on_urltree_unselect_row";

    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

#    print STDERR "on_urltree_unselect_row\n";
    clear_requestClist($instance);
#    clear_request_details($instance,$pid); # FIXME, need $pid!
#    $form->{"logviewClist"}->unselect;

    # FIXME - clear the details
    # FIXME - clear the logview side as well

}    # End of sub on_urltree_unselect_row#}}}

sub show_requestClist {    #{{{
    my $instance = shift;
    my $url      = shift;

    my $form         = $__PACKAGE__::all_forms->{$instance};
    my $requestClist = $form->{requestClist};
    my $logtable     = $form->{logViewClist};
    foreach my $pid ( @{ $__PACKAGE__::urlpids{$url} } ) {
        my $method = $logtable->get_text( $__PACKAGE__::logrow[$pid], 1 );
        my $query  = $logtable->get_text( $__PACKAGE__::logrow[$pid], 4 );
        my $result = $logtable->get_text( $__PACKAGE__::logrow[$pid], 5 );
        my $cookie = $logtable->get_text( $__PACKAGE__::logrow[$pid], 6 );
        $requestClist->append( $pid, $method, $query, $result, $cookie );
    }
}    #}}}

sub clear_requestClist {    #{{{
    my $instance = shift;
    my $seq      = shift;

    my $form         = $__PACKAGE__::all_forms->{$instance};
    my $requestClist = $form->{requestClist};

    $requestClist->clear();
    clear_request_details( $instance, $seq );
}    #}}}

sub show_request_details {    #{{{
    local *CONTENT;
    my $instance = shift;
    my $seq      = shift;

    return if ($__PACKAGE__::requestdetails);

    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};

    my $logfile = $__PACKAGE__::datadir;

    my $file = "${logfile}log-$seq-fromclient";
    if ( -r $file ) {
        my $field = $form->{requestRawText};
        $field->freeze;
        open( CONTENT, "$file" ) || warn "Can't open $file\n";
        while ( my $line = <CONTENT> ) {
            $field->insert( undef, undef, undef, $line );
        }
        $field->set_point(0);
        $field->thaw;
        close(CONTENT);

        $field = $form->{detailHeaderClist};
        open( CONTENT, "$file" ) || warn "Can't open $file\n";
        my $line = <CONTENT>;
        while ( $line = <CONTENT> ) {

            # I have no idea why chomp does not work here!
            $line =~ s/\n//g;
            last if ( $line eq '' );
            my ( $header, $value ) = split ( ': ', $line, 2 );
            $field->append( $header, $value );
        }

        $field = $form->{detailQueryClist};

        # handle fragments 'path.html;fragment=x?query=1&var=2'
        my $uri= piduri($seq);
        my $fragquery = uri_query( $uri, "query" );
        my ( $fragment, $query ) = split ( /\?/, $fragquery, 2 );
        if ( !defined $query ) { $query = $fragment; }
        else { $field->append( "FRAGMENT", $fragment ); }

        # handle URL query params
        my @pairs = split ( '&', $query );
        while ( my $pair = shift @pairs ) {
            my ( $variable, $value ) = split ( '=', $pair, 2 );
            $field->append( $variable, $value );
        }

        # handle Content query params. Need to extend to handle different Content MIME-Types FIXME
        while ( $line = <CONTENT> ) {

            # I have no idea why chomp does not work here!
            $line =~ s/\n//g;
            next if ( $line eq '' );
            my @pairs = split ( '&', $line );
            while ( my $param = shift @pairs ) {
                my ( $variable, $value ) = split ( '=', $param, 2 );
                $field->append( $variable, $value );
            }
        }

    }

    $file = "${logfile}log-$seq-fromserver";
    if ( -r $file ) {
        my $html=0;
        my $blank=0;
        my $content='';
        my $field = $form->{responseRawText};
        $field->freeze;
        open( CONTENT, "$file" ) || warn "Can't open $file\n";
        while ( my $line = <CONTENT> ) {
            $field->insert( undef, undef, undef, $line );
            $line=~s/\n//g; $line=~s/\r//g;
            if (!$blank && $line=~/text\/html/) { $html=1; }
            if (!$blank && $line eq "") { $blank=1; next; }
            if ($blank && $html) { $content.=$line."\n"; }
        }
        $field->set_point(0);
        $field->thaw;
        if ($__PACKAGE__::XmHTML && $html) {
          print STDERR "About to set HTML\n";
          $form->{responseHTML}->source($content);
          print STDERR "about to render HTML\n";
          $form->{responseHTML}->show();
          print STDERR "done\n";
        }
        close(CONTENT);
    }

    $file = "${logfile}log-$seq-desc";
    if ( -r $file ) {
        my $field = $form->{descriptionEntry};
        open( CONTENT, "$file" ) || warn "Can't open $file\n";
        my $line = <CONTENT>;
        $field->set_text($line);
        close(CONTENT);
    }
    $__PACKAGE__::requestdetails=1;
}    #}}}

sub clear_request_details {    #{{{
    my $instance = shift;
    my $seq      = shift;

    return if (! $__PACKAGE__::requestdetails);

#    print STDERR "clear_request_details\n";

    my $logfile = $__PACKAGE__::datadir;
    my $form    = $__PACKAGE__::all_forms->{$instance};

    my $field   = $form->{requestRawText};

    # Prevents us trying to clear an already cleared field, and 
    # overwriting/deleting the description
    # FIXME
    #    return if ($field->get_text eq '');

    $field->freeze;
    $field->set_point(0);
    $field->forward_delete( $field->get_length() );
    $field->thaw;

    $field = $form->{responseRawText};
    $field->freeze;
    $field->set_point(0);
    $field->forward_delete( $field->get_length() );
    $field->thaw;
    
    if ($__PACKAGE__::XmHTML) {
      print STDERR "About to clear an HTML field\n";
      $field = $form->{responseHTML};
      $field->freeze;
      $field->source('');
      $field->thaw();
    }

    $field = $form->{detailHeaderClist};
    $field->freeze;
    $field->clear;
    $field->thaw;

    $field = $form->{detailQueryClist};
    $field->freeze;
    $field->clear;
    $field->thaw;

    $field = $form->{descriptionEntry};
    writedescription($seq,$field->get_text());
    $field->set_text('');

    $__PACKAGE__::requestdetails=0;
}    #}}}

sub writedescription {    #{{{
    local *DESC;
    my $seq=shift;
    my $message=shift;

    my $file = $__PACKAGE__::datadir."log-$seq-desc";
    if ( $message ne '' ) {
        open( DESC, ">$file" )
          || warn "Couldn't write description for $seq: $!\n";
        my $success=print DESC $message;
        close(DESC);
        if ( ! -f $file ) { die "Didn't write anything!\n"; }
    } elsif ( -e $file ) {    # clean it up if we have no description any more
        unlink $file || warn "Can't unlink $file: $!\n";
    }
}    #}}}

#===============================================================================
#==== Service routines
#===============================================================================

# Use this subroutine to read in data from a file handle, or stdin
# set it up with:
#   my $timer = Gtk->timeout_add( 500, \&tail_log, $instance, $filehandle);
sub tail_log {    #{{{
    my $instance = shift;
    my $form = $__PACKAGE__::all_forms->{'main-1'};
    my @lines    = ();
    if ($__PACKAGE__::timer) { Gtk->timeout_remove( $__PACKAGE__::timer ); }

    my ($package, $filename, $line) = caller;
    print STDERR "At $package, $filename, $line\n" if ($__PACKAGE__::trace);

    foreach my $logfile (@__PACKAGE__::logfiles) {
        my $fh=$__PACKAGE__::logfiles{$logfile};
        next if (! defined $fh);
        my ( $bytes, $i, $got ) = ( 0, 0, '' );

        my $rin = '';
        vec( $rin, fileno($fh), 1 ) = 1;
        my $found = select( $rin, undef, undef, 0.01 );
        while ( $found && ( $bytes = sysread( $fh, $got, 2048 ) ) ) {
            $__PACKAGE__::in[ fileno($fh) ] .= $got;
            $got = '';
            while (
                ( my $i = index( $__PACKAGE__::in[ fileno($fh) ], "\n" ) ) > -1 ) {
                my $line = substr( $__PACKAGE__::in[ fileno($fh) ], 0, $i + 1, '' );
                push @lines, $line;
#                print "Read '$line'\n";
            }
            $found = select( $rin, undef, undef, 0.1 );
#            if ( $#lines > 50 ) {    # Bailing to process what I've got!
#                $found = 0;
#            }
          Gtk->main_iteration while ( Gtk->events_pending );
        }
    }
    if ( $#lines > -1 ) { addlines( $instance, @lines ); }

    # we must return 1, otherwise we cancel the handler
    if ($__PACKAGE__::timer) {
        $__PACKAGE__::timer =
          Gtk->timeout_add( 500, \&tail_log, $__PACKAGE__::window->INSTANCE );
    }
    return 1;
}    #}}}

sub addlines {    #{{{
    my $instance = shift;
    my @lines    = @_;
    my $count    = 0;

    my $form     = $__PACKAGE__::all_forms->{$instance};

    my $statusbar=$form->{'statusbar'};
    my $context=$statusbar->get_context_id( 'Processing' );
    $statusbar->push($context,"Processed $count lines");


    # MASSIVE KLUGE to prevent segfault if we html->show in app_run :-(
    if ($__PACKAGE__::XmHTML) { $form->{responseHTML}->show(); }

    my $logtable = $form->{"logViewClist"};
    $logtable->freeze;
    my $ctree = $form->{"urltree"};
    $ctree->freeze;

    my $methods = 'GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT';

    while ( my $line = shift @lines ) {
        $count++;
        if ($count % 50 == 0) { 
            $logtable->thaw; 
            $logtable->freeze;
            $ctree->thaw; 
            $ctree->freeze;
            $statusbar->pop($context);
            $statusbar->push($context,"Processed $count lines");
        }
        Gtk->main_iteration while ( Gtk->events_pending );
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+($methods)\s+(.*)$/ ) {
            my $pid    = $1;
            my $method = $2;
            my $uri    = URI->new($3);
            my $url    =
              $uri->scheme . "://"
              . $uri->host . ":"
              . $uri->port
              . uri_path( $uri, "query" );
            my $shp   = $uri->scheme . "://" . $uri->host . ":" . $uri->port;
            my $path  = uri_path( $uri, "query" );
            my $query = uri_query( $uri, "query" );

            $__PACKAGE__::piduri[$1] = $uri;
            push @{ $__PACKAGE__::urlpids{$url} }, $pid;
            if ( $uri->query
                && !exists $__PACKAGE__::nodedata->{$url}->{'GETFORM'} ) {
                $__PACKAGE__::nodedata->{$url}->{'GETFORM'} = 1;
            }
            if ( ( $2 eq "POST" )
                && !exists $__PACKAGE__::nodedata->{$url}->{'POSTFORM'} ) {
                $__PACKAGE__::nodedata->{$url}->{'POSTFORM'} = 1;
            }
            if ($url!~/\.(?:gif|jpg|png)$/i) {
                $__PACKAGE__::logrow[$pid] =
                  $logtable->append( $pid, $method, $shp, $path, $query, '', '' );
                if ( -r $__PACKAGE__::datadir . "log-$pid-desc" ) {
                    $logtable->set_foreground(
                        $__PACKAGE__::logrow[$pid],
                        $__PACKAGE__::color{"DESCRIPTION"}
                    );
                }
            }
            if ( !exists $__PACKAGE__::treenode{$url} ) {
                set_node( $ctree, $uri );
            }
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+Content\:\s+(.*)$/ ) {

            # Client sent POST data, but we don't care.
            # We've already noted that it is a POST form above
            # we could use this data to identify variables sent . . . FIXME?
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+MD5\s+(.*)$/ ) {

            # proxy calculated an MD5 sum for us . . .
            # We don't care
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+Cookie :\s+(.*)$/ ) {

            # Client sent a Cookie
            # We don't care
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+Set-Cookie:\s+(.*)$/ ) {

            # Server returned "Set-Cookie"
            my $pid    = $1;
            my $cookie = $2;
            my $uri    = piduri($pid);
            my $url    =
              $uri->scheme . "://"
              . $uri->host . ":"
              . $uri->port
              . uri_path( $uri, "query" );
            if ( !exists $__PACKAGE__::nodedata->{$url}->{'SET-COOKIE'} ) {
                $__PACKAGE__::nodedata->{$url}->{'SET-COOKIE'} = 1;
            }
            $logtable->set_text( $__PACKAGE__::logrow[$pid], 6, $cookie );
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+(\d\d\d\s+.*)$/ ) {

            # Server sent response code
            my $pid  = $1;
            my $code = $2;
            my $uri  = piduri($pid);
            my $url  =
              $uri->scheme . "://"
              . $uri->host . ":"
              . $uri->port
              . uri_path( $uri, "query" );
            $logtable->set_text( $__PACKAGE__::logrow[$pid], 5, $code );
            if ( !exists $__PACKAGE__::nodedata->{$url}->{'visited'} ) {
                $__PACKAGE__::nodedata->{$url}->{'visited'} = 1;
                $ctree->node_set_background( $__PACKAGE__::treenode{$url},
                    $__PACKAGE__::color{"SEEN"} );
            }
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+(Script|Form|Comment|XSS): (.*)$/ ) {

            # We have an interesting thing in the body of this page
            my $pid   = $1;
            my $found = $2;
            my $where = $3;
            my $uri   = piduri($pid);
            my $url   =
              $uri->scheme . "://"
              . $uri->host . ":"
              . $uri->port
              . uri_path( $uri, "query" );
            if (! exists $__PACKAGE__::nodedata->{$url}->{$found}) {
                push @{$__PACKAGE__::nodedata->{$url}->{$found}},$where;
                set_node($__PACKAGE__::window->{'FORM'}->{'urltree'},$uri);
            } else {
                push @{$__PACKAGE__::nodedata->{$url}->{$found}},$where;
            }
            next;
        }
        if ( $line =~ /^\s*(\d+)\s+\d+\s+\#\s+vulnxml \w+ (.*)$/ ) {

            # We have a link that we may or may not have visited before
            my $pid = $1;
            my $uri = URI->new($2);;
            my $url =
              $uri->scheme . "://"
              . $uri->host . ":"
              . $uri->port
              . uri_path( $uri, "query" );
            if ( !exists $__PACKAGE__::treenode{$url} ) {
                set_node($__PACKAGE__::window->{'FORM'}->{'urltree'},$uri);
            }
            next;
        }
        print STDERR "What to do with '$line'\n";
    }
    $statusbar->pop($context);
    $logtable->thaw;
    $ctree->thaw;
    return;
}    #}}}

sub sameparent {    #{{{
    my $url1 = shift;
    my $url2 = shift;

    if ( substr( $url1, -1 ) eq '/' ) {
        $url1 = substr( $url1, 0, length($url1) - 1 );
    }
    if ( substr( $url2, -1 ) eq '/' ) {
        $url2 = substr( $url2, 0, length($url2) - 1 );
    }
    my $base1 = substr( $url1, 0, rindex( $url1, '/' ) );
    my $base2 = substr( $url2, 0, rindex( $url2, '/' ) );

    die "base1 = ''\n" if ( !$base1 );
    return ( $base1 eq $base2 );
}    #}}}

sub set_node {    #{{{
    my $ctree       = shift;
    my $uri         = shift;
    my $flagcolumns = 6;
    my @flags;
    foreach my $i ( 1 .. $flagcolumns ) { push @flags, ''; }

    # Check if the top level Scheme:Host:Port exists
    my $shp = $uri->scheme . "://" . $uri->host . ":" . $uri->port . "/";
    if ( !exists $__PACKAGE__::treenode{$shp} ) {
        my $sibling = undef;
        foreach my $url ( sort keys %__PACKAGE__::treenode ) {
            if ( $url gt $shp ) {
                $sibling = $__PACKAGE__::treenode{$url};
                last;
            }
        }
        $__PACKAGE__::treenode{$shp} =
          $ctree->insert_node( undef, $sibling, [ @flags, $shp ],
            10, undef, undef, undef, undef, 0, 1 );
        $ctree->node_set_text( $__PACKAGE__::treenode{$shp}, 0, $shp );
        $ctree->node_set_background( $__PACKAGE__::treenode{$shp},
            $__PACKAGE__::color{"UNSEEN"} );
    }
    if ( uri_path( $uri, "query" ) ne '/' && uri_path( $uri, "query" ) ne '' ) {
        my @dirs = split ( '/', uri_path( $uri, "query" ), -1 );
        my $file = pop @dirs;
        shift @dirs;
        my $parent = $shp;
        foreach my $dir (@dirs) {
            if ( !exists $__PACKAGE__::treenode{ $parent . $dir . '/' } ) {
                my $sibling = undef;
                foreach my $url ( sort keys %__PACKAGE__::treenode ) {
                    if ( $url gt $parent . $dir . '/'
                        && sameparent( $url, $parent . $dir . '/' ) ) {
                        $sibling = $__PACKAGE__::treenode{$url};
                        last;
                    }
                }
                $__PACKAGE__::treenode{ $parent . $dir . '/' } =
                  $ctree->insert_node(
                    $__PACKAGE__::treenode{$parent},
                    $sibling, [ @flags, $dir . '/' ],
                    10, undef, undef, undef, undef, 0, 1
                  );
                $ctree->node_set_text(
                    $__PACKAGE__::treenode{ $parent . $dir . '/' },
                    0, $parent . $dir . '/' );
                $ctree->node_set_background(
                    $__PACKAGE__::treenode{ $parent . $dir . '/' },
                    $__PACKAGE__::color{"UNSEEN"} );
            }
            $parent .= $dir . '/';
        }
        if ( !exists $__PACKAGE__::treenode{ $parent . $file } ) {
            my $sibling = undef;
            foreach my $url ( sort keys %__PACKAGE__::treenode ) {
                if ( $url gt $parent . $file
                    && sameparent( $url, $parent . $file ) ) {
                    $sibling = $__PACKAGE__::treenode{$url};
                    last;
                }
            }
            $__PACKAGE__::treenode{ $parent . $file } = $ctree->insert_node(
                $__PACKAGE__::treenode{$parent},
                $sibling, [ @flags, $file ],
                10, undef, undef, undef, undef, 0, 1
            );
            $ctree->node_set_text( $__PACKAGE__::treenode{ $parent . $file },
                0, $parent . $file );
            $ctree->node_set_background(
                $__PACKAGE__::treenode{ $parent . $file },
                $__PACKAGE__::color{"UNSEEN"} );
        }
    }

    my $url =
      $uri->scheme . "://"
      . $uri->host . ":"
      . $uri->port
      . uri_path( $uri, "query" );
    $ctree->node_set_text( $__PACKAGE__::treenode{$url}, 0, $url );

    #    $ctree->node_set_text($__PACKAGE__::treenode{$url},$flagcolumns+1,$url);
    return 1 if ( !defined $__PACKAGE__::nodedata->{$url} );
    foreach ( keys %{ $__PACKAGE__::nodedata->{$url} } ) {
        /POSTFORM/ && do {
            $ctree->node_set_pixmap(
                $__PACKAGE__::treenode{$url},
                1, get_form_pixmap( $__PACKAGE__::window->TOPLEVEL ),
            );
            next;
        };
        /GETFORM/ && do {
            $ctree->node_set_pixmap(
                $__PACKAGE__::treenode{$url},
                1, get_form_pixmap( $__PACKAGE__::window->TOPLEVEL ),
            );
            next;
        };
        /XSS/ && do {
            $ctree->node_set_pixmap(
                $__PACKAGE__::treenode{$url},
                2, get_xss_pixmap( $__PACKAGE__::window->TOPLEVEL ),
            );
            next;
        };
        /Script/ && do {
            $ctree->node_set_pixmap(
                $__PACKAGE__::treenode{$url},
                3, get_script_pixmap( $__PACKAGE__::window->TOPLEVEL ),
            );
            next;
        };
        /Comment/ && do {
            $ctree->node_set_pixmap(
                $__PACKAGE__::treenode{$url},
                4, get_comment_pixmap( $__PACKAGE__::window->TOPLEVEL ),
            );
            next;
        };
        /SET-COOKIE/ && do {
            $ctree->node_set_pixmap(
                $__PACKAGE__::treenode{$url},
                5, get_cookie_pixmap( $__PACKAGE__::window->TOPLEVEL ),
            );
            next;
        };
    }

    #    $ctree->moveto($__PACKAGE__::treenode[$1],0,1.0,0.0);
    return 1;
}    #}}}

sub get_form_pixmap {    #{{{
    my $window = shift;
    my $attr   = shift;

    # XPM data of Open-File icon
    my @xpm_data = (
        "16 16 4 1",
        "       c None s None",
        ".      c black",
        "X      c #808080",
        "o      c white",
        "                ",
        " .............  ",
        " .............  ",
        " .............  ",
        " .............  ",
        " ....           ",
        " ....           ",
        " .........      ",
        " .........      ",
        " .........      ",
        " .........      ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        "                "
    );

    my $style = $window->get_style()->bg('normal');
    my ( $pixmap, $mask ) =
      Gtk::Gdk::Pixmap->create_from_xpm_d( $window->window, $style, @xpm_data );

    return ( $pixmap, $mask );
}    #}}}
sub get_script_pixmap {    #{{{
    my $window = shift;
    my $attr   = shift;

    # XPM data of Open-File icon
    my @xpm_data = (
        "16 16 4 1",
        "       c None s None",
        ".      c black",
        "X      c #808080",
        "o      c white",
        "                ",
        " .............  ",
        " .............  ",
        " .............  ",
        " ....           ",
        " ....           ",
        " ....           ",
        " .............  ",
        " .............  ",
        " .............  ",
        "          ....  ",
        "          ....  ",
        "          ....  ",
        " .............  ",
        " .............  ",
        " .............  "
    );

    my $style = $window->get_style()->bg('normal');
    my ( $pixmap, $mask ) =
      Gtk::Gdk::Pixmap->create_from_xpm_d( $window->window, $style, @xpm_data );

    return ( $pixmap, $mask );
}    #}}}
sub get_comment_pixmap {    #{{{
    my $window = shift;
    my $attr   = shift;

    # XPM data of Open-File icon
    my @xpm_data = (
        "16 16 4 1",
        "       c None s None",
        ".      c black",
        "X      c #808080",
        "o      c white",
        "                ",
        " .............  ",
        " .............  ",
        " .............  ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        " ....           ",
        " .............  ",
        " .............  ",
        " .............  "
    );

    my $style = $window->get_style()->bg('normal');
    my ( $pixmap, $mask ) =
      Gtk::Gdk::Pixmap->create_from_xpm_d( $window->window, $style, @xpm_data );

    return ( $pixmap, $mask );
}    #}}}
sub get_xss_pixmap {    #{{{
    my $window = shift;
    my $attr   = shift;

    # XPM data of Open-File icon
    my @xpm_data = (
        "16 16 4 1",
        "       c None s None",
        ".      c black",
        "X      c #808080",
        "o      c white",
        "                ",
        " ....     ....  ",
        " ....     ....  ",
        "  ....   ....   ",
        "  ....   ....   ",
        "   .... ....    ",
        "   .... ....    ",
        "    .......     ",
        "    .......     ",
        "    .......     ",
        "   .... ....    ",
        "   .... ....    ",
        "  ....   ....   ",
        "  ....   ....   ",
        " ....     ....  ",
        " ....     ....  "
    );

    my $style = $window->get_style()->bg('normal');
    my ( $pixmap, $mask ) =
      Gtk::Gdk::Pixmap->create_from_xpm_d( $window->window, $style, @xpm_data );

    return ( $pixmap, $mask );
}    #}}}
sub get_cookie_pixmap {    #{{{
    my $window = shift;
    my $attr   = shift;

    # XPM data of Open-File icon
    my @xpm_data = (
        "16 16 4 1",
        "       c None s None",
        ".      c black",
        "X      c #808080",
        "o      c white",
        "                ",
        "   .......      ",
        "  ... ......    ",
        " ....... ....   ",
        " ... .........  ",
        " ... .... ....  ",
        " ...... ... ..  ",
        " .......... ..  ",
        " .... . ......  ",
        " ........... .  ",
        " ....... .. ..  ",
        " ... ... .....  ",
        " .............  ",
        "  .. ........   ",
        "   ...... ..    ",
        "     .....      "
    );

    my $style = $window->get_style()->bg('normal');
    my ( $pixmap, $mask ) =
      Gtk::Gdk::Pixmap->create_from_xpm_d( $window->window, $style, @xpm_data );

    return ( $pixmap, $mask );
}    #}}}

# Convenience functions for handling parameters i.e. /path;sessid=1?a=1

sub uri_path {    #{{{
    my $uri   = shift;
    my $param = shift;
    if ( defined $param && $param ne "path" ) {
        return join ( "/", $uri->path_segments() );
    } else {
        return $uri->path();
    }
}    #}}}

sub uri_params {    #{{{
    my $uri   = shift;
    my $param = shift;
    if ( defined $param && $param eq "param" ) {
        foreach my $segment ( $uri->path_segments() ) {
            if ( ref $segment ) {
                shift @$segment;
                return join ( ";", @$segment );
            }
        }
    }
    return "";
}    #}}}

sub uri_query {    #{{{
    my $uri   = shift;
    my $param = shift;
    if ( defined $param && $param eq "query" ) {
        my $params = uri_params( $uri, "param" );
        if ($params) { $params .= "?"; }
        return $params . $uri->query();
    } else {
        return $uri->query;
    }
}    #}}}

sub piduri {    #{{{
    my $pid   = shift;

    my $uri = $__PACKAGE__::piduri[$pid];
    if (! defined $uri) {
        die "Error getting URI from pid for '$pid'\n";
    }
    return $uri;
}    #}}}
1;

__END__

#===============================================================================
#==== Documentation
#===============================================================================
=pod

=head1 NAME

Exodus - version 0.01 Thu Nov  7 23:04:40 SAST 2002

No description

=head1 SYNOPSIS

 use Exodus;

 To construct the window object and show it call
 
 Gtk->init;
 my $window = Exodus->new;
 $window->TOPLEVEL->show;
 Gtk->main;
 
 OR use the shorthand for the above calls
 
 Exodus->app_run;

=head1 DESCRIPTION

Unfortunately, the author has not yet written any documentation :-(

=head1 AUTHOR

 <rdawes\@deloitte.co.za>

=cut

