#!/usr/bin/perl -w

# This file defines the CTree manually, because Glade forces the tree to be
# in the first column, which we don't want.

# Call it like

#    Gtk->init;
#    my $window = $class->new;
#    $__PACKAGE__::window=$window;

#    define_urltree($window,'treewindow');
#    $window->{'FORM'}->{'hpaned1'}->set_position(400);
#    $window->{'FORM'}->{'main'}->set_usize(800,600);

#    $window->TOPLEVEL->show;

#    Gtk->main;

sub define_urltree {
    my $window=shift;
    my $parent=shift;
    my $widgets;
    my $forms=$window->{'FORM'};
    my $instance=$window->{'INSTANCE'};
    my $flagcolumns=6;
    my $class="Exodus";
    #
    # Construct a GtkCTree 'urltree'
    $widgets->{'urltree'} = new Gtk::CTree($flagcolumns+1, $flagcolumns );
    $widgets->{'urltree'}->set_selection_mode('single' );
    $widgets->{'urltree'}->set_border('in' );
#    $widgets->{'urltree'}->column_titles_show;
#    $widgets->{'urltree'}->set_column_visibility(0, 0);
#    $widgets->{'urltree'}->set_column_resizeable(0, 0);
#    $widgets->{'urltree'}->set_column_auto_resize(0, 0);
    foreach my $i (1..$flagcolumns-1) {
        $widgets->{'urltree'}->set_column_width($i, 16 );
        $widgets->{'urltree'}->set_column_resizeable($i, 0);
        $widgets->{'urltree'}->set_column_auto_resize($i, 0);
    }
    $widgets->{'urltree'}->set_column_width($flagcolumns, 400 );
    $widgets->{'urltree'}->set_column_resizeable($flagcolumns, 1);
    $widgets->{'urltree'}->set_column_auto_resize($flagcolumns, 1);

    $forms->{$parent}->add($widgets->{'urltree'} );
    $widgets->{'urltree'}->signal_connect( 'button_press_event', \&on_urltree_button_press_event, '', 'urltree', $instance );
    $widgets->{'urltree'}->show;
    $forms->{'urltree'} = $widgets->{'urltree'};
    $forms->{'urltree'}->can_focus(1 );

    $widgets->{'urltree'}->signal_connect('select_row', "$class\::on_urltree_select_row", '', 'urltree', "$instance" );
    $widgets->{'urltree'}->signal_connect('unselect_row', "$class\::on_urltree_unselect_row", '', 'urltree', "$instance" );

#        #
#        # Construct a GtkLabel 'label1'
#        $widgets->{'label1'} = new Gtk::Label(_('FLAGS'));
#        $widgets->{'label1'}->set_justify('center' );
#        $widgets->{'label1'}->set_line_wrap(0 );
#        $forms->{'urltree'}->set_column_widget(0, $widgets->{'label1'} );
#        $widgets->{'label1'}->show;
#        $forms->{'label1'} = $widgets->{'label1'};
#        $forms->{'label1'}->set_usize(150, 0 );
#        $forms->{'label1'}->set_alignment(0.5, 0.5 );
#        #
#        # Construct a GtkLabel 'label2'
#        $widgets->{'label2'} = new Gtk::Label(_('URL'));
#        $widgets->{'label2'}->set_justify('center' );
#        $widgets->{'label2'}->set_line_wrap(0 );
#        $forms->{'urltree'}->set_column_widget(1, $widgets->{'label2'} );
#        $widgets->{'label2'}->show;
#        $forms->{'label2'} = $widgets->{'label2'};
#        $forms->{'label2'}->set_alignment(0.5, 0.5 );
        #
        # Construct a Menu 'urlpopup'
	$widgets->{'urlpopup'} = new Gtk::Menu;
	$forms->{'urlpopup'}=$widgets->{'urlpopup'};
            #
            # Construct a MenuItem 'item1'
	    $widgets->{'item1'} = new Gtk::MenuItem("Item 1");
	    $forms->{'urlpopup'}->append($widgets->{'item1'});
	    $widgets->{'item1'}->signal_connect( 'activate', \&item1_selected, '', 'item1', $instance );
	    $widgets->{'item1'}->show;
            #
            # Construct a MenuItem 'item1'
	    $widgets->{'item2'} = new Gtk::MenuItem("Item 2");
	    $forms->{'urlpopup'}->append($widgets->{'item2'});
	    $widgets->{'item2'}->signal_connect( 'activate', \&item2_selected, '', 'item2', $instance );
	    $widgets->{'item2'}->show;
            #
            # Construct a MenuItem 'item1'
	    $widgets->{'item3'} = new Gtk::MenuItem("Item 3");
	    $forms->{'urlpopup'}->append($widgets->{'item3'});
	    $widgets->{'item3'}->signal_connect( 'activate', \&item3_selected, '', 'item3', $instance );
	    $widgets->{'item3'}->show;

}

sub on_urltree_button_press_event {
    my ($class, $data, $object, $instance, $event) = @_;
    my $me = __PACKAGE__."->on_urltree_button_press_event";
    # Get ref to hash of all widgets on our form
    my $form = $__PACKAGE__::all_forms->{$instance};
#    print Dumper($form); # exit;

    # REPLACE the line below with the actions to be taken when __PACKAGE__."->on_urltree_button_press_event." is called
    if ($event->{button} == 3) {
        print "Right Mouse button!\n";
        $form->{'urlpopup'}->popup( undef, undef, 0, $event->{'button'}, undef );
        return 1;
    }

#    __PACKAGE__->show_skeleton_message($me, \@_, __PACKAGE__, "$Glade::PerlRun::pixmaps_directory/glade2perl_logo.xpm");

} # End of sub on_urltree_button_press_event

1;

__END__
