#!/usr/bin/perl -w

# sample mangle.include file

# This file is included into mangle.pl dynamically, so any changes made
# will take effect from the next request received.

# NB: Make sure that the file ends with "1;" on the last line to tell Perl
# that the inclusion was successful

# manglerequest and mangleresponse get Perl HTTP::Request and ::Response
# objects passed to them as parameters. You can use all the methods
# available for them to query or change the content of these objects.
# See "man HTTP::Request" or "man HTTP::Response" for details

# defined global variables that can be tested:
# $addr = client source IP addr
# $port = client source port

# other than that, just make sure that you keep your own variables local.
# If you modify anything, you probably want to log the changes using 
# Record("toserver",$request) and Record("toclient",$response)
# This happens automatically if there are any changes detected.

# You can also define your own supporting functions here, just be careful
# not to clobber any existing functions already used by mangle.pl!

sub manglerequest { # mangles the client request as required
  my $request=shift;
  
  # this clears any possibility of the server returning "Use your cache"
  # messages - This caused some breakage previously
  # It's not worth logging this as a change, (for EVERY page)
  # so we do this BEFORE we create $orig
  $request->remove_header("if-modified-since");
  $request->remove_header("if-none-match");

  my $orig = $request->as_string("\r\n");
  if ($request->uri->as_string()=~/ballotselection2.jhtml/) {
    $request=modify_POST_variable($request,"seatCat1427","1234");
    $request=modify_POST_variable($request,"num1299","99");
#    $request=modify_POST_variable($request,"pay_rec__status","SUCCESS");
#    $request=modify_POST_variable($request,"pay_rec__err_code","0000");
#    $request=modify_POST_variable($request,"pay_rec__err_message","NO ERROR");
  }

#  my $loggedon="0002RQ04H5QAAAB4BQFIFQJ1UTA";
#
#  if (defined $request->header("cookie")) {
#    my $c=$request->header("cookie");
#    if (defined $loggedon && ($c=~/sesessionid/)) {
#      $c=~s/0001\w+/$loggedon/;
#      $c=~s/0002\w+/$loggedon/;
#      $request->header("cookie" => $c);
#      Log("Modified Cookie : ".$request->header("cookie"));
#    }
#  }
#
  # Only Record if the request changed
  if ($request->as_string("\r\n") ne $orig) {
    Record("toserver",$request);
  }
  return $request;
}

sub mangleresponse { # mangles the server response as required
  my $response=shift;

  my $orig = $response->as_string("\r\n");

  # International Trade
#  if ($response->request->uri=~/formLogin/) {
#    my $content=$response->content();
#    $content=~s/PCT02/PCT01/g;
#    $response->content($content);
#  }
#  if (($response->content_type=~/html/) ||
#      ($response->content_type=~/javascript/)) {
#    # Make hidden fields visible . . .
#    my $content=$response->content();
#    $content=~s/type="hidden"/  type="text"/ig;
#    $content=~s/type='hidden'/  type='text'/ig;
#    $content=~s/CONTENT="1500;URL=https:/CONTENT="0060;      URL=/ig;
##    $content=~s/5221008300021412/5221008300021420/ig;
#     $content=~s/document.forms.redirect_form.submit/document.forms.redirect_form.sumbit/ig;
#    $response->content($content);
#  }

#  if (defined $response->header("set-cookie")) {
#    my $c=$response->header("Set-Cookie");
#    if (defined $loggedon && ($c=~/sesessionid/)) {
#      $c=~s/0001\w+/$loggedon/;
#      $c=~s/0002\w+/$loggedon/;
#      $response->header("set-cookie" => $c);
#      Log("Modified Set-Cookie : ".$response->header("set-cookie"));
#    }
#  }
#
  # Only Record if the response changed
  if ($response->as_string("\r\n") ne $orig) {
    Record("toclient",$response);
  }
  return $response;
}

sub modify_POST_variable {
  my $request=shift;
  my $variable=shift;
  my $value=shift;
  my $body='';

  if ($request->method ne "POST") {
    print STDERR "Called for a non-POST request : '",$request->uri->as_string,"'\n";
    return $request;
  }
  my @values=split('&',$request->content());
  foreach (my $i=0; $i<=$#values; $i++) {
    $values[$i]=~/(.*?)=(.*)/ && do { $name = $1; $val=$2; };
    if ($name eq $variable) {
      print STDERR "'$variable' was '$val', now it is '$value'\n";
      $values[$i]=$name.'='.$value;
      last;
    }
  }
  $body=join('&',@values);
  $request->content($body);
  $request->content_length(length($body));
  return $request;
}




1;
