#!/bin/bash


default_http_proxy="http://cachejnb.dtt.co.za:80/"
default_https_proxy="http://cachejnb.dtt.co.za:80/"
mangleport=8080
mangleopts="-i -m mangle.inc -p $mangleport"

MANGLE=`pwd`
if [ "$http_proxy" == "" ] ; then
  echo -n "Set an upstream HTTP proxy (y/N) ? "
  read yn
  if [ "$yn" == "y" ] ; then
    echo -n "Enter proxy address [default=$default_http_proxy]: "
    read proxy
    if [ "$proxy" == "" ] ; then
      http_proxy=$default_http_proxy
    else
      http_proxy=$proxy
    fi
  fi
fi

if [ "$https_proxy" == "" ] ; then
  echo -n "Set an upstream HTTPS proxy (y/N) ? "
  read yn
  if [ "$yn" == "y" ] ; then
    echo -n "Enter proxy address [default=$default_https_proxy]: "
    read proxy
    if [ "$proxy" == "" ] ; then
      https_proxy=$default_https_proxy
    else
      https_proxy=$proxy
    fi
  fi
fi

savedir=$1;

while [ -z "$savedir" ] ; do
  echo -n "Save results to? "
  read savedir
done

trap 'eval "echo Killing $manglepid $analysepid $exoduspid ; kill $manglepid $analysepid $exoduspid" ; exit' SIGINT

echo "Running mangle.pl"

echo "Launching mangle.pl $mangleopts -f $savedir"
./mangle.pl $mangleopts -f $savedir &
manglepid=$!
sleep 5

echo "Launching analyse.pl $savedir"
./analyse.pl $savedir &
analysepid=$!

if [ -n "$DISPLAY" ] ; then
  echo "Launching exodus GUI"
  cd exodus2
  ./exodus.pl ../$savedir &
  exoduspid=$!
  cd ..
fi

echo
echo "Now point your browser to port $mangleport on this server, and start surfing!"
echo "Press ^C to exit and clean up"
echo

while /bin/true ; do
  sleep 5
done
